/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.keys.memory;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.redback.keys.AbstractKeyManager;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;
import org.codehaus.plexus.redback.keys.memory.MemoryAuthenticationKey;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="keyManager#memory")
public class MemoryKeyManager
extends AbstractKeyManager {
    private Map<String, AuthenticationKey> keys = new HashMap<String, AuthenticationKey>();

    public AuthenticationKey createKey(String principal, String purpose, int expirationMinutes) throws KeyManagerException {
        MemoryAuthenticationKey key = new MemoryAuthenticationKey();
        key.setKey(super.generateUUID());
        key.setForPrincipal(principal);
        key.setPurpose(purpose);
        key.setDateCreated(new Date());
        if (expirationMinutes >= 0) {
            Calendar expiration = Calendar.getInstance();
            expiration.add(12, expirationMinutes);
            key.setDateExpires(expiration.getTime());
        }
        this.keys.put(key.getKey(), key);
        return key;
    }

    public AuthenticationKey findKey(String key) throws KeyNotFoundException, KeyManagerException {
        if (StringUtils.isEmpty((String)key)) {
            throw new KeyNotFoundException("Empty key not found.");
        }
        AuthenticationKey authkey = this.keys.get(key);
        if (authkey == null) {
            throw new KeyNotFoundException("Key [" + key + "] not found.");
        }
        this.assertNotExpired(authkey);
        return authkey;
    }

    public void deleteKey(AuthenticationKey authkey) throws KeyManagerException {
        this.keys.remove(authkey);
    }

    public void deleteKey(String key) throws KeyManagerException {
        AuthenticationKey authkey = this.keys.get(key);
        if (authkey != null) {
            this.keys.remove(authkey);
        }
    }

    public List<AuthenticationKey> getAllKeys() {
        return new ArrayList<AuthenticationKey>(this.keys.values());
    }

    public AuthenticationKey addKey(AuthenticationKey key) {
        this.keys.put(key.getKey(), key);
        return key;
    }

    public void eraseDatabase() {
        this.keys.clear();
    }

    public String getId() {
        return "Memory Key Manager";
    }
}

