/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.CookieSettings;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.PasswordRule;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.PolicyContext;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.UserValidationSettings;
import org.codehaus.plexus.redback.policy.rules.MustHavePasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="userSecurityPolicy")
public class DefaultUserSecurityPolicy
implements UserSecurityPolicy,
Initializable,
Contextualizable {
    private static final String ENABLEMENT_KEY = ROLE + ":ENABLED";
    public static final String PASSWORD_RETENTION_COUNT = "security.policy.password.previous.count";
    public static final String LOGIN_ATTEMPT_COUNT = "security.policy.allowed.login.attempt";
    public static final String PASSWORD_EXPIRATION_ENABLED = "security.policy.password.expiration.enabled";
    public static final String PASSWORD_EXPIRATION = "security.policy.password.expiration.days";
    public static final String PASSWORD_ENCODER = "security.policy.password.encoder";
    public static final String UNLOCKABLE_ACCOUNTS = "security.policy.unlockable.accounts";
    private static final Logger log = LoggerFactory.getLogger(DefaultUserSecurityPolicy.class);
    private PasswordRule defaultPasswordRule = new MustHavePasswordRule();
    private PlexusContainer plexus;
    @Resource(name="userConfiguration")
    private UserConfiguration config;
    @Resource(name="passwordEncoder#sha256")
    private PasswordEncoder passwordEncoder;
    @Resource(name="userValidationSettings")
    private UserValidationSettings userValidationSettings;
    @Resource(name="cookieSettings#rememberMe")
    private CookieSettings rememberMeCookieSettings;
    @Resource(name="cookieSettings#signon")
    private CookieSettings signonCookieSettings;
    private List<PasswordRule> rules = new ArrayList<PasswordRule>();
    private int previousPasswordsCount;
    private int loginAttemptCount;
    private int passwordExpirationDays;
    private boolean passwordExpirationEnabled;
    private List<String> unlockableAccounts;

    public void initialize() throws InitializationException {
        this.configurePolicy();
        this.configureEncoder();
        try {
            this.rules = this.plexus.lookupList(PasswordRule.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
        if (this.rules == null) {
            this.rules = new ArrayList<PasswordRule>();
        }
        if (this.rules.isEmpty()) {
            this.addPasswordRule(this.defaultPasswordRule);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.plexus = (PlexusContainer)context.get((Object)"plexus");
    }

    private void configureEncoder() throws InitializationException {
        String encoder = this.config.getString(PASSWORD_ENCODER);
        if (encoder != null) {
            try {
                this.passwordEncoder = (PasswordEncoder)this.plexus.lookup(PasswordEncoder.ROLE, encoder);
            }
            catch (ComponentLookupException e) {
                throw new InitializationException("Unable to lookup password encoder.", (Throwable)e);
            }
        }
    }

    private void configurePolicy() {
        this.previousPasswordsCount = this.config.getInt(PASSWORD_RETENTION_COUNT);
        this.loginAttemptCount = this.config.getInt(LOGIN_ATTEMPT_COUNT);
        this.passwordExpirationEnabled = this.config.getBoolean(PASSWORD_EXPIRATION_ENABLED);
        this.passwordExpirationDays = this.config.getInt(PASSWORD_EXPIRATION);
        this.unlockableAccounts = this.config.getList(UNLOCKABLE_ACCOUNTS);
    }

    @Override
    public String getId() {
        return "Default User Security Policy";
    }

    @Override
    public int getPreviousPasswordsCount() {
        return this.previousPasswordsCount;
    }

    @Override
    public List<String> getUnlockableAccounts() {
        if (this.unlockableAccounts == null) {
            this.unlockableAccounts = new ArrayList<String>();
        }
        return this.unlockableAccounts;
    }

    @Override
    public void setUnlockableAccounts(List<String> unlockableAccounts) {
        this.unlockableAccounts = unlockableAccounts;
    }

    @Override
    public void setPreviousPasswordsCount(int count) {
        this.previousPasswordsCount = count;
    }

    @Override
    public int getLoginAttemptCount() {
        return this.loginAttemptCount;
    }

    @Override
    public void setLoginAttemptCount(int count) {
        this.loginAttemptCount = count;
    }

    @Override
    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    @Override
    public boolean isEnabled() {
        Boolean bool = (Boolean)PolicyContext.getContext().get(ENABLEMENT_KEY);
        return bool == null || bool != false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        PolicyContext.getContext().put(ENABLEMENT_KEY, enabled);
    }

    @Override
    public void addPasswordRule(PasswordRule rule) {
        rule.setUserSecurityPolicy(this);
        this.rules.add(rule);
    }

    @Override
    public List<PasswordRule> getPasswordRules() {
        return this.rules;
    }

    @Override
    public void setPasswordRules(List<PasswordRule> rules) {
        this.rules.clear();
        if (rules == null) {
            return;
        }
        for (PasswordRule rule : rules) {
            this.addPasswordRule(rule);
        }
    }

    @Override
    public void extensionPasswordExpiration(User user) throws MustChangePasswordException {
        if (this.passwordExpirationEnabled && !this.getUnlockableAccounts().contains(user.getUsername())) {
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.setTime(user.getLastPasswordChange());
            expirationDate.add(5, this.passwordExpirationDays);
            Calendar now = Calendar.getInstance();
            if (now.after(expirationDate)) {
                log.info("User '" + user.getUsername() + "' flagged for password expiry (expired on: " + expirationDate + ")");
                user.setPasswordChangeRequired(true);
                throw new MustChangePasswordException("Password Expired, You must change your password.", user);
            }
        }
    }

    @Override
    public void extensionExcessiveLoginAttempts(User user) throws AccountLockedException {
        if (!this.getUnlockableAccounts().contains(user.getUsername())) {
            int attempt = user.getCountFailedLoginAttempts();
            user.setCountFailedLoginAttempts(++attempt);
            if (attempt >= this.loginAttemptCount) {
                log.info("User '" + user.getUsername() + "' locked due to excessive login attempts: " + attempt);
                user.setLocked(true);
                throw new AccountLockedException("Account " + user.getUsername() + " is locked.", user);
            }
        }
    }

    @Override
    public void extensionChangePassword(User user) throws PasswordRuleViolationException {
        this.extensionChangePassword(user, false);
    }

    @Override
    public void extensionChangePassword(User user, boolean passwordChangeRequired) throws PasswordRuleViolationException {
        this.validatePassword(user);
        user.setEncodedPassword(this.passwordEncoder.encodePassword(user.getPassword()));
        user.setPassword(null);
        ArrayList<String> previousPasswords = new ArrayList<String>();
        previousPasswords.add(user.getEncodedPassword());
        if (!user.getPreviousEncodedPasswords().isEmpty()) {
            int oldCount = Math.min(this.previousPasswordsCount - 1, user.getPreviousEncodedPasswords().size());
            List sublist = user.getPreviousEncodedPasswords().subList(0, oldCount);
            previousPasswords.addAll(sublist);
        }
        user.setPreviousEncodedPasswords(previousPasswords);
        user.setPasswordChangeRequired(passwordChangeRequired);
        user.setLastPasswordChange(new Date());
    }

    @Override
    public void validatePassword(User user) throws PasswordRuleViolationException {
        if (this.isEnabled()) {
            PasswordRuleViolations violations = new PasswordRuleViolations();
            for (PasswordRule rule : this.rules) {
                if (!rule.isEnabled()) continue;
                if (rule.requiresSecurityPolicy()) {
                    rule.setUserSecurityPolicy(this);
                }
                rule.testPassword(violations, user);
            }
            if (violations.hasViolations()) {
                PasswordRuleViolationException exception = new PasswordRuleViolationException();
                exception.setViolations(violations);
                throw exception;
            }
        }
        if (user.getPassword() == null) {
            user.setPassword("");
        }
    }

    @Override
    public int getPasswordExpirationDays() {
        return this.passwordExpirationDays;
    }

    @Override
    public void setPasswordExpirationDays(int passwordExpiry) {
        this.passwordExpirationDays = passwordExpiry;
    }

    @Override
    public UserValidationSettings getUserValidationSettings() {
        return this.userValidationSettings;
    }

    @Override
    public void setUserValidationSettings(UserValidationSettings settings) {
        this.userValidationSettings = settings;
    }

    @Override
    public CookieSettings getRememberMeCookieSettings() {
        return this.rememberMeCookieSettings;
    }

    @Override
    public CookieSettings getSignonCookieSettings() {
        return this.signonCookieSettings;
    }
}

