/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.encoders;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.PasswordEncodingException;
import org.codehaus.plexus.redback.users.Messages;
import org.codehaus.plexus.util.StringUtils;
import sun.misc.BASE64Encoder;

public class AbstractJAASPasswordEncoder
implements PasswordEncoder {
    private String algorithm;
    private Object systemSalt;

    public AbstractJAASPasswordEncoder(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setSystemSalt(Object salt) {
        this.systemSalt = salt;
    }

    public String encodePassword(String rawPass, Object salt) {
        if (rawPass == null) {
            throw new IllegalArgumentException("rawPass parameter cannot be null.");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.algorithm);
            String precode = rawPass;
            if (salt != null) {
                precode = precode + "{" + salt + "}";
            }
            md.update(precode.getBytes("UTF-8"));
            byte[] raw = md.digest();
            return new BASE64Encoder().encode(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PasswordEncodingException(Messages.getString((String)"password.encoder.no.such.algoritm", (Object)this.algorithm), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new PasswordEncodingException(Messages.getString((String)"password.encoder.unsupported.encoding"), e);
        }
    }

    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        if (StringUtils.isEmpty((String)encPass)) {
            return false;
        }
        String testPass = this.encodePassword(rawPass, salt);
        return encPass.equals(testPass);
    }

    public String encodePassword(String rawPass) {
        return this.encodePassword(rawPass, this.systemSalt);
    }

    public boolean isPasswordValid(String encPass, String rawPass) {
        return this.isPasswordValid(encPass, rawPass, this.systemSalt);
    }
}

