/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#alpha-numeric")
public class AlphaNumericPasswordRule
extends AbstractPasswordRule {
    public static final String ALPHANUM_VIOLATION = "user.password.violation.alphanum.only";

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        char[] password = user.getPassword().toCharArray();
        for (int i = 0; i < password.length; ++i) {
            if (Character.isLetterOrDigit(password[i])) continue;
            violations.addViolation(ALPHANUM_VIOLATION);
            return;
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.alphanumeric.enabled");
    }
}

