/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#alpha-count")
public class AlphaPasswordRule
extends AbstractPasswordRule {
    public static final String ALPHA_COUNT_MIN = "security.policy.password.rule.alphacount.minimum";
    public static final String ALPHA_COUNT_VIOLATION = "user.password.violation.alpha";
    private int minimumCount;

    private int countAlphaCharacters(String password) {
        int count = 0;
        if (StringUtils.isEmpty((String)password)) {
            return count;
        }
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isLetter(c)) continue;
            ++count;
        }
        return count;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public void setMinimumCount(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        if (this.countAlphaCharacters(user.getPassword()) < this.minimumCount) {
            violations.addViolation(ALPHA_COUNT_VIOLATION, new Object[]{String.valueOf(this.minimumCount)});
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.alphacount.enabled");
        this.minimumCount = this.config.getInt(ALPHA_COUNT_MIN);
    }
}

