/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#character-length")
public class CharacterLengthPasswordRule
extends AbstractPasswordRule {
    public static final String CHARACTER_LENGTH_MIN = "security.policy.password.rule.characterlength.minimum";
    public static final String CHARACTER_LENGTH_MAX = "security.policy.password.rule.characterlength.maximum";
    public static final String CHARACTER_LENGTH_MISCONFIGURED_VIOLATION = "user.password.violation.length.misconfigured";
    public static final String CHARACTER_LENGTH_VIOLATION = "user.password.violation.length";
    public static final int DEFAULT_CHARACTER_LENGTH_MAX = 8;
    private int minimumCharacters;
    private int maximumCharacters;

    public int getMaximumCharacters() {
        return this.maximumCharacters;
    }

    public int getMinimumCharacters() {
        return this.minimumCharacters;
    }

    public void setMaximumCharacters(int maximumCharacters) {
        this.maximumCharacters = maximumCharacters;
    }

    public void setMinimumCharacters(int minimumCharacters) {
        this.minimumCharacters = minimumCharacters;
    }

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        String password;
        if (this.minimumCharacters > this.maximumCharacters) {
            violations.addViolation(CHARACTER_LENGTH_MISCONFIGURED_VIOLATION, new Object[]{String.valueOf(this.minimumCharacters), String.valueOf(this.maximumCharacters)});
        }
        if (StringUtils.isEmpty((String)(password = user.getPassword())) || password.length() < this.minimumCharacters || password.length() > this.maximumCharacters) {
            violations.addViolation(CHARACTER_LENGTH_VIOLATION, new Object[]{String.valueOf(this.minimumCharacters), String.valueOf(this.maximumCharacters)});
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.characterlength.enabled");
        this.minimumCharacters = this.config.getInt(CHARACTER_LENGTH_MIN);
        this.maximumCharacters = this.config.getInt(CHARACTER_LENGTH_MAX);
    }
}

