/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#numerical-count")
public class NumericalPasswordRule
extends AbstractPasswordRule {
    public static final String MINIMUM = "security.policy.password.rule.numericalcount.minimum";
    public static final String NUMERICAL_COUNT_VIOLATION = "user.password.violation.numeric";
    private int minimumCount;

    private int countDigitCharacters(String password) {
        int count = 0;
        if (StringUtils.isEmpty((String)password)) {
            return count;
        }
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (!Character.isDigit(c)) continue;
            ++count;
        }
        return count;
    }

    public int getMinimumCount() {
        return this.minimumCount;
    }

    public void setMinimumCount(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        if (this.countDigitCharacters(user.getPassword()) < this.minimumCount) {
            violations.addViolation(NUMERICAL_COUNT_VIOLATION, new Object[]{String.valueOf(this.minimumCount)});
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.numericalcount.enabled");
        this.minimumCount = this.config.getInt(MINIMUM);
    }
}

