/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import java.util.Iterator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#reuse")
public class ReusePasswordRule
extends AbstractPasswordRule {
    public static final String REUSE_VIOLATION = "user.password.violation.reuse";
    private UserSecurityPolicy securityPolicy;

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
        this.securityPolicy = policy;
    }

    public boolean requiresSecurityPolicy() {
        return true;
    }

    public int getPreviousPasswordCount() {
        if (this.securityPolicy == null) {
            throw new IllegalStateException("The security policy has not yet been set.");
        }
        return this.securityPolicy.getPreviousPasswordsCount();
    }

    private boolean hasReusedPassword(User user, String password) {
        if (this.securityPolicy == null) {
            throw new IllegalStateException("The security policy has not yet been set.");
        }
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String encodedPassword = this.securityPolicy.getPasswordEncoder().encodePassword(password);
        Iterator it = user.getPreviousEncodedPasswords().iterator();
        for (int checkCount = this.getPreviousPasswordCount(); it.hasNext() && checkCount >= 0; --checkCount) {
            String prevEncodedPassword = (String)it.next();
            if (!encodedPassword.equals(prevEncodedPassword)) continue;
            return true;
        }
        return false;
    }

    public void setPreviousPasswordCount(int previousPasswordCount) {
        this.securityPolicy.setPreviousPasswordsCount(previousPasswordCount);
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        String password = user.getPassword();
        if (this.hasReusedPassword(user, password)) {
            violations.addViolation(REUSE_VIOLATION, new Object[]{String.valueOf(this.getPreviousPasswordCount())});
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.reuse.enabled");
    }
}

