/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.policy.rules;

import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.policy.rules.AbstractPasswordRule;
import org.codehaus.plexus.redback.users.User;
import org.springframework.stereotype.Service;

@Service(value="passwordRule#no-whitespaces")
public class WhitespacePasswordRule
extends AbstractPasswordRule {
    public static final String NO_WHITE_SPACE_VIOLATION = "user.password.violation.whitespace.detected";

    public void setUserSecurityPolicy(UserSecurityPolicy policy) {
    }

    public void testPassword(PasswordRuleViolations violations, User user) {
        if (user.getPassword() != null) {
            char[] password = user.getPassword().toCharArray();
            for (int i = 0; i < password.length; ++i) {
                if (!Character.isWhitespace(password[i])) continue;
                violations.addViolation(NO_WHITE_SPACE_VIOLATION);
                return;
            }
        }
    }

    public void initialize() throws InitializationException {
        this.enabled = this.config.getBoolean("security.policy.password.rule.nowhitespace.enabled");
    }
}

