/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.rbac.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.redback.rbac.AbstractRBACManager;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RBACObjectAssertions;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.RbacObjectInvalidException;
import org.codehaus.plexus.redback.rbac.RbacObjectNotFoundException;
import org.codehaus.plexus.redback.rbac.RbacPermanentException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.rbac.memory.MemoryOperation;
import org.codehaus.plexus.redback.rbac.memory.MemoryPermission;
import org.codehaus.plexus.redback.rbac.memory.MemoryResource;
import org.codehaus.plexus.redback.rbac.memory.MemoryRole;
import org.codehaus.plexus.redback.rbac.memory.MemoryUserAssignment;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="rBACManager#memory")
public class MemoryRbacManager
extends AbstractRBACManager
implements RBACManager {
    private Map<String, Role> roles = new HashMap<String, Role>();
    private Map<String, Permission> permissions = new HashMap<String, Permission>();
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    private Map<String, UserAssignment> userAssignments = new HashMap<String, UserAssignment>();
    private boolean hasTriggeredInit = false;

    public Role saveRole(Role role) throws RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Save Role", (Role)role);
        this.triggerInit();
        this.roles.put(role.getName(), role);
        this.fireRbacRoleSaved(role);
        if (role.getPermissions() != null) {
            for (Permission p : role.getPermissions()) {
                this.savePermission(p);
            }
        }
        return role;
    }

    public void saveRoles(Collection<Role> roles) throws RbacObjectInvalidException, RbacManagerException {
        if (roles == null) {
            return;
        }
        for (Role role : roles) {
            this.saveRole(role);
        }
    }

    private void assertRoleExists(String roleName) throws RbacObjectNotFoundException {
        if (!this.roles.containsKey(roleName)) {
            throw new RbacObjectNotFoundException("Role '" + roleName + "' does not exist.");
        }
    }

    public Role getRole(String roleName) throws RbacObjectNotFoundException {
        this.triggerInit();
        this.assertRoleExists(roleName);
        return this.roles.get(roleName);
    }

    public void removeRole(Role role) throws RbacManagerException, RbacObjectNotFoundException {
        RBACObjectAssertions.assertValid((String)"Remove Role", (Role)role);
        if (role.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent role [" + role.getName() + "]");
        }
        this.assertRoleExists(role.getName());
        this.fireRbacRoleRemoved(role);
        this.roles.remove(role.getName());
    }

    public List<Role> getAllRoles() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<Role>(this.roles.values()));
    }

    public Operation saveOperation(Operation operation) throws RbacManagerException {
        this.triggerInit();
        RBACObjectAssertions.assertValid((String)"Save Operation", (Operation)operation);
        this.operations.put(operation.getName(), operation);
        return operation;
    }

    public Permission savePermission(Permission permission) throws RbacManagerException {
        this.triggerInit();
        RBACObjectAssertions.assertValid((String)"Save Permission", (Permission)permission);
        this.permissions.put(permission.getName(), permission);
        this.fireRbacPermissionSaved(permission);
        this.saveOperation(permission.getOperation());
        this.saveResource(permission.getResource());
        return permission;
    }

    public Resource saveResource(Resource resource) throws RbacManagerException {
        this.triggerInit();
        RBACObjectAssertions.assertValid((String)"Save Resource", (Resource)resource);
        this.resources.put(resource.getIdentifier(), resource);
        return resource;
    }

    public UserAssignment saveUserAssignment(UserAssignment userAssignment) throws RbacManagerException {
        this.triggerInit();
        RBACObjectAssertions.assertValid((String)"Save UserAssignment", (UserAssignment)userAssignment);
        this.fireRbacUserAssignmentSaved(userAssignment);
        this.userAssignments.put(userAssignment.getPrincipal(), userAssignment);
        return userAssignment;
    }

    public Operation createOperation(String name) throws RbacManagerException {
        Operation operation;
        try {
            operation = this.getOperation(name);
        }
        catch (RbacObjectNotFoundException e) {
            operation = new MemoryOperation();
            operation.setName(name);
        }
        return operation;
    }

    public Permission createPermission(String name) throws RbacManagerException {
        Permission permission;
        try {
            permission = this.getPermission(name);
        }
        catch (RbacObjectNotFoundException e) {
            permission = new MemoryPermission();
            permission.setName(name);
        }
        return permission;
    }

    public Permission createPermission(String name, String operationName, String resourceIdentifier) throws RbacManagerException {
        Permission permission;
        try {
            permission = this.getPermission(name);
            if (StringUtils.equals((String)operationName, (String)permission.getOperation().getName())) {
                throw new RbacManagerException("Attempted to create a permission named '" + name + "' with an operation named '" + operationName + "', but that overides the existing '" + name + "' permission with operation '" + permission.getOperation().getName() + "'");
            }
        }
        catch (RbacObjectNotFoundException e) {
            permission = new MemoryPermission();
            permission.setName(name);
            permission.setOperation(this.createOperation(operationName));
            permission.setResource(this.createResource(resourceIdentifier));
        }
        return permission;
    }

    public Resource createResource(String identifier) throws RbacManagerException {
        Resource resource;
        try {
            resource = this.getResource(identifier);
        }
        catch (RbacObjectNotFoundException e) {
            resource = new MemoryResource();
            resource.setIdentifier(identifier);
        }
        return resource;
    }

    public Role createRole(String name) {
        MemoryRole role = new MemoryRole();
        role.setName(name);
        return role;
    }

    private void assertPermissionExists(String permissionName) throws RbacObjectNotFoundException {
        if (!this.permissions.containsKey(permissionName)) {
            throw new RbacObjectNotFoundException("Permission '" + permissionName + "' does not exist.");
        }
    }

    public Permission getPermission(String permissionName) throws RbacObjectNotFoundException, RbacManagerException {
        this.triggerInit();
        this.assertPermissionExists(permissionName);
        return this.permissions.get(permissionName);
    }

    public List<Resource> getResources() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<Resource>(this.resources.values()));
    }

    public void removeOperation(Operation operation) throws RbacObjectNotFoundException, RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Remove Operation", (Operation)operation);
        if (operation.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent operation [" + operation.getName() + "]");
        }
        this.assertOpertionExists(operation.getName());
        this.operations.remove(operation.getName());
    }

    private void assertOpertionExists(String operationName) throws RbacObjectNotFoundException {
        if (!this.operations.containsKey(operationName)) {
            throw new RbacObjectNotFoundException("Operation '" + operationName + "' not found.");
        }
    }

    public void removePermission(Permission permission) throws RbacObjectNotFoundException, RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Remove Permission", (Permission)permission);
        if (permission.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent permission [" + permission.getName() + "]");
        }
        this.assertPermissionExists(permission.getName());
        this.fireRbacPermissionRemoved(permission);
        this.permissions.remove(permission.getName());
    }

    public void removeResource(Resource resource) throws RbacObjectNotFoundException, RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Remove Resource", (Resource)resource);
        if (resource.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent resource [" + resource.getIdentifier() + "]");
        }
        this.assertResourceExists(resource.getIdentifier());
        this.resources.remove(resource.getIdentifier());
    }

    private void assertResourceExists(String resourceIdentifier) throws RbacObjectNotFoundException {
        if (!this.resources.containsKey(resourceIdentifier)) {
            throw new RbacObjectNotFoundException("Resource '" + resourceIdentifier + "' not found.");
        }
    }

    private void assertUserAssignmentExists(String principal) throws RbacObjectNotFoundException {
        if (!this.userAssignments.containsKey(principal)) {
            throw new RbacObjectNotFoundException("UserAssignment '" + principal + "' not found.");
        }
    }

    public void removeUserAssignment(UserAssignment userAssignment) throws RbacObjectNotFoundException, RbacManagerException {
        RBACObjectAssertions.assertValid((String)"Remove User Assignment", (UserAssignment)userAssignment);
        if (userAssignment.isPermanent()) {
            throw new RbacPermanentException("Unable to delete permanent user assignment [" + userAssignment.getPrincipal() + "]");
        }
        this.fireRbacUserAssignmentRemoved(userAssignment);
        this.assertUserAssignmentExists(userAssignment.getPrincipal());
        this.userAssignments.remove(userAssignment.getPrincipal());
    }

    public void eraseDatabase() {
        this.userAssignments.clear();
        this.resources.clear();
        this.operations.clear();
        this.permissions.clear();
        this.roles.clear();
    }

    public UserAssignment createUserAssignment(String principal) throws RbacManagerException {
        try {
            return this.getUserAssignment(principal);
        }
        catch (RbacObjectNotFoundException e) {
            MemoryUserAssignment ua = new MemoryUserAssignment();
            ua.setPrincipal(principal);
            this.fireRbacUserAssignmentSaved(ua);
            return ua;
        }
    }

    public List<Operation> getAllOperations() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<Operation>(this.operations.values()));
    }

    public List<Permission> getAllPermissions() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<Permission>(this.permissions.values()));
    }

    public List<Resource> getAllResources() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<Resource>(this.resources.values()));
    }

    public List<UserAssignment> getAllUserAssignments() throws RbacManagerException {
        this.triggerInit();
        return Collections.unmodifiableList(new ArrayList<UserAssignment>(this.userAssignments.values()));
    }

    public List<UserAssignment> getUserAssignmentsForRoles(Collection<String> roleNames) throws RbacManagerException {
        ArrayList<UserAssignment> userAssignments = new ArrayList<UserAssignment>();
        block0: for (UserAssignment ua : this.getAllUserAssignments()) {
            for (String roleName : roleNames) {
                if (!ua.getRoleNames().contains(roleName)) continue;
                userAssignments.add(ua);
                continue block0;
            }
        }
        return userAssignments;
    }

    public UserAssignment getUserAssignment(String principal) throws RbacObjectNotFoundException, RbacManagerException {
        this.triggerInit();
        this.assertUserAssignmentExists(principal);
        return this.userAssignments.get(principal);
    }

    public Operation getOperation(String operationName) throws RbacObjectNotFoundException, RbacManagerException {
        this.triggerInit();
        this.assertOpertionExists(operationName);
        return this.operations.get(operationName);
    }

    public Resource getResource(String resourceIdentifier) throws RbacObjectNotFoundException, RbacManagerException {
        this.triggerInit();
        this.assertResourceExists(resourceIdentifier);
        return this.resources.get(resourceIdentifier);
    }

    public void triggerInit() {
        if (!this.hasTriggeredInit) {
            this.fireRbacInit(this.roles.isEmpty());
            this.hasTriggeredInit = true;
        }
    }
}

