/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.rbac;

import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RbacObjectInvalidException;
import org.codehaus.plexus.redback.rbac.Resource;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.util.StringUtils;

public class RBACObjectAssertions {
    public static void assertValid(Role role) throws RbacObjectInvalidException {
        RBACObjectAssertions.assertValid(null, role);
    }

    public static void assertValid(String scope, Role role) throws RbacObjectInvalidException {
        if (role == null) {
            throw new RbacObjectInvalidException(scope, "Null Role object is invalid.");
        }
        if (StringUtils.isEmpty((String)role.getName())) {
            throw new RbacObjectInvalidException(scope, "Role.name must not be empty.");
        }
        if (role.getPermissions() != null) {
            int i = 0;
            for (Permission perm : role.getPermissions()) {
                RBACObjectAssertions.assertValid("Role.permissions[" + i + "]", perm);
                ++i;
            }
        }
    }

    public static void assertValid(Permission permission) throws RbacObjectInvalidException {
        RBACObjectAssertions.assertValid(null, permission);
    }

    public static void assertValid(String scope, Permission permission) throws RbacObjectInvalidException {
        if (permission == null) {
            throw new RbacObjectInvalidException(scope, "Null Permission object is invalid.");
        }
        if (StringUtils.isEmpty((String)permission.getName())) {
            throw new RbacObjectInvalidException(scope, "Permission.name must not be empty.");
        }
        RBACObjectAssertions.assertValid("Permission.operation", permission.getOperation());
        RBACObjectAssertions.assertValid("Permission.resource", permission.getResource());
    }

    public static void assertValid(Operation operation) throws RbacObjectInvalidException {
        RBACObjectAssertions.assertValid(null, operation);
    }

    public static void assertValid(String scope, Operation operation) throws RbacObjectInvalidException {
        if (operation == null) {
            throw new RbacObjectInvalidException(scope, "Null Operation object is invalid.");
        }
        if (StringUtils.isEmpty((String)operation.getName())) {
            throw new RbacObjectInvalidException(scope, "Operation.name must not be empty.");
        }
    }

    public static void assertValid(Resource resource) throws RbacObjectInvalidException {
        RBACObjectAssertions.assertValid(null, resource);
    }

    public static void assertValid(String scope, Resource resource) throws RbacObjectInvalidException {
        if (resource == null) {
            throw new RbacObjectInvalidException(scope, "Null Resource object is invalid.");
        }
        if (StringUtils.isEmpty((String)resource.getIdentifier())) {
            throw new RbacObjectInvalidException(scope, "Resource.identifier must not be empty.");
        }
    }

    public static void assertValid(UserAssignment assignment) throws RbacObjectInvalidException {
        RBACObjectAssertions.assertValid(null, assignment);
    }

    public static void assertValid(String scope, UserAssignment assignment) throws RbacObjectInvalidException {
        if (assignment == null) {
            throw new RbacObjectInvalidException(scope, "Null UserAssigment object is invalid.");
        }
        if (StringUtils.isEmpty((String)assignment.getPrincipal())) {
            throw new RbacObjectInvalidException(scope, "UserAssigment.principal cannot be empty.");
        }
        if (assignment.getRoleNames() == null) {
            throw new RbacObjectInvalidException(scope, "UserAssignment.roles cannot be null.");
        }
        int i = 0;
        for (String name : assignment.getRoleNames()) {
            if (StringUtils.isEmpty((String)name)) {
                throw new RbacObjectInvalidException(scope, "UserAssignment.rolename[" + i + "] cannot be empty.");
            }
            ++i;
        }
    }
}

