/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.role;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.stream.XMLStreamException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.rbac.UserAssignment;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.ModelTemplate;
import org.codehaus.plexus.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.redback.role.model.io.stax.RedbackRoleModelStaxReader;
import org.codehaus.plexus.redback.role.processor.RoleModelProcessor;
import org.codehaus.plexus.redback.role.template.RoleTemplateProcessor;
import org.codehaus.plexus.redback.role.util.RoleModelUtils;
import org.codehaus.plexus.redback.role.validator.RoleModelValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="roleManager")
public class DefaultRoleManager
implements RoleManager,
Initializable {
    private Logger log = LoggerFactory.getLogger(DefaultRoleManager.class);
    private RedbackRoleModel blessedModel;
    private RedbackRoleModel unblessedModel;
    private Map<String, ModelApplication> knownResources = new HashMap<String, ModelApplication>();
    @Resource(name="roleModelValidator")
    private RoleModelValidator modelValidator;
    @Resource(name="roleModelProcessor")
    private RoleModelProcessor modelProcessor;
    @Resource(name="roleTemplateProcessor")
    private RoleTemplateProcessor templateProcessor;
    @Resource(name="rBACManager#cached")
    private RBACManager rbacManager;

    public void loadRoleModel(URL resource) throws RoleManagerException {
        RedbackRoleModelStaxReader reader = new RedbackRoleModelStaxReader();
        try {
            RedbackRoleModel roleModel = reader.read(new InputStreamReader(resource.openStream()));
            for (ModelApplication app : roleModel.getApplications()) {
                if (this.knownResources.containsKey(app.getId())) continue;
                this.log.info("loading " + app.getId());
                this.loadApplication(app);
            }
        }
        catch (MalformedURLException e) {
            throw new RoleManagerException("error locating redback profile", e);
        }
        catch (IOException e) {
            throw new RoleManagerException("error reading redback profile", e);
        }
        catch (XMLStreamException e) {
            throw new RoleManagerException("error parsing redback profile", e);
        }
    }

    public void loadRoleModel(RedbackRoleModel roleModel) throws RoleManagerException {
        for (ModelApplication app : roleModel.getApplications()) {
            if (this.knownResources.containsKey(app.getId())) continue;
            this.loadApplication(app);
        }
    }

    public void loadApplication(ModelApplication app) throws RoleManagerException {
        if (this.unblessedModel == null) {
            this.unblessedModel = new RedbackRoleModel();
        }
        this.unblessedModel.addApplication(app);
        if (!this.modelValidator.validate(this.unblessedModel)) {
            this.log.error("Role Model Validation Errors:");
            for (String error : this.modelValidator.getValidationErrors()) {
                this.log.error(error);
            }
            throw new RoleManagerException("Role Model Validation Error");
        }
        this.blessedModel = this.unblessedModel;
        this.modelProcessor.process(this.blessedModel);
        this.knownResources.put(app.getId(), app);
    }

    public void createTemplatedRole(String templateId, String resource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, resource);
    }

    public void removeTemplatedRole(String templateId, String resource) throws RoleManagerException {
        ModelTemplate template = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        String roleName = template.getNamePrefix() + template.getDelimiter() + resource;
        try {
            Role role = this.rbacManager.getRole(roleName);
            for (UserAssignment assignment : this.rbacManager.getUserAssignmentsForRoles(Arrays.asList(role.getName()))) {
                assignment.removeRoleName(role);
                this.rbacManager.saveUserAssignment(assignment);
            }
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("unable to remove role", e);
        }
        this.templateProcessor.remove(this.blessedModel, templateId, resource);
    }

    public void updateRole(String templateId, String oldResource, String newResource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, newResource);
        ModelTemplate template = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        String oldRoleName = template.getNamePrefix() + template.getDelimiter() + oldResource;
        String newRoleName = template.getNamePrefix() + template.getDelimiter() + newResource;
        try {
            Role role = this.rbacManager.getRole(oldRoleName);
            for (UserAssignment assignment : this.rbacManager.getUserAssignmentsForRoles(Arrays.asList(role.getName()))) {
                assignment.removeRoleName(oldRoleName);
                assignment.addRoleName(newRoleName);
                this.rbacManager.saveUserAssignment(assignment);
            }
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("unable to update role", e);
        }
        this.templateProcessor.remove(this.blessedModel, templateId, oldResource);
    }

    public void assignRole(String roleId, String principal) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            throw new RoleManagerException("Unable to assign role: " + roleId + " does not exist.");
        }
        try {
            UserAssignment userAssignment = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
            userAssignment.addRoleName(modelRole.getName());
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    public void assignTemplatedRole(String templateId, String resource, String principal) throws RoleManagerException {
        ModelTemplate modelTemplate = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        if (modelTemplate == null) {
            throw new RoleManagerException("Unable to assign role: " + templateId + " does not exist.");
        }
        try {
            if (!this.rbacManager.resourceExists(resource)) {
                org.codehaus.plexus.redback.rbac.Resource newResource = this.rbacManager.createResource(resource);
                this.rbacManager.saveResource(newResource);
            }
            UserAssignment userAssignment = this.rbacManager.userAssignmentExists(principal) ? this.rbacManager.getUserAssignment(principal) : this.rbacManager.createUserAssignment(principal);
            userAssignment.addRoleName(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter() + resource);
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    public void unassignRole(String roleId, String principal) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            throw new RoleManagerException("Unable to assign role: " + roleId + " does not exist.");
        }
        try {
            if (!this.rbacManager.userAssignmentExists(principal)) {
                throw new RoleManagerException("UserAssignment for principal " + principal + "does not exist, can't unassign role.");
            }
            UserAssignment userAssignment = this.rbacManager.getUserAssignment(principal);
            userAssignment.removeRoleName(modelRole.getName());
            this.rbacManager.saveUserAssignment(userAssignment);
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("Unable to assign role: unable to manage user assignment", e);
        }
    }

    public boolean roleExists(String roleId) throws RoleManagerException {
        ModelRole modelRole = RoleModelUtils.getModelRole(this.blessedModel, roleId);
        if (modelRole == null) {
            return false;
        }
        if (this.rbacManager.roleExists(modelRole.getName())) {
            return true;
        }
        throw new RoleManagerException("breakdown in role management, role exists in configuration but was not created in underlying store");
    }

    public boolean templatedRoleExists(String templateId, String resource) throws RoleManagerException {
        ModelTemplate modelTemplate = RoleModelUtils.getModelTemplate(this.blessedModel, templateId);
        if (modelTemplate == null) {
            return false;
        }
        return this.rbacManager.roleExists(modelTemplate.getNamePrefix() + modelTemplate.getDelimiter() + resource);
    }

    public void initialize() throws InitializationException {
        try {
            URL baseResource = RoleManager.class.getResource("/META-INF/redback/redback-core.xml");
            if (baseResource == null) {
                throw new InitializationException("unable to initialize role manager, missing redback-core.xml");
            }
            this.loadRoleModel(baseResource);
            Enumeration<URL> enumerator = RoleManager.class.getClassLoader().getResources("META-INF/redback/redback.xml");
            while (enumerator.hasMoreElements()) {
                URL redbackResource = enumerator.nextElement();
                this.loadRoleModel(redbackResource);
            }
        }
        catch (RoleManagerException e) {
            throw new InitializationException("unable to initialize RoleManager", (Throwable)e);
        }
        catch (IOException e) {
            throw new InitializationException("unable to initialize RoleManager, problem with redback.xml loading", (Throwable)e);
        }
    }

    public RedbackRoleModel getModel() {
        return this.blessedModel;
    }

    public void verifyTemplatedRole(String templateId, String resource) throws RoleManagerException {
        this.templateProcessor.create(this.blessedModel, templateId, resource);
    }
}

