/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.role.model.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelOperation;
import org.codehaus.plexus.redback.role.model.ModelPermission;
import org.codehaus.plexus.redback.role.model.ModelResource;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.ModelTemplate;
import org.codehaus.plexus.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class RedbackRoleModelStaxReader {
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private ModelApplication parseModelApplication(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelApplication modelApplication = new ModelApplication();
        modelApplication.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("version");
                modelApplication.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelApplication.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelApplication.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("longDescription")) {
                if (parsed.contains("longDescription")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("longDescription");
                modelApplication.setLongDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resources")) {
                if (parsed.contains("resources")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resources");
                ArrayList resources = new ArrayList();
                modelApplication.setResources(resources);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("resource")) {
                        modelApplication.addResource(this.parseModelResource("resource", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("operations")) {
                if (parsed.contains("operations")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("operations");
                ArrayList operations = new ArrayList();
                modelApplication.setOperations(operations);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("operation")) {
                        modelApplication.addOperation(this.parseModelOperation("operation", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("roles")) {
                if (parsed.contains("roles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("roles");
                ArrayList roles = new ArrayList();
                modelApplication.setRoles(roles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("role")) {
                        modelApplication.addRole(this.parseModelRole("role", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("templates")) {
                if (parsed.contains("templates")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("templates");
                ArrayList templates = new ArrayList();
                modelApplication.setTemplates(templates);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("template")) {
                        modelApplication.addTemplate(this.parseModelTemplate("template", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelApplication;
    }

    private ModelOperation parseModelOperation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelOperation modelOperation = new ModelOperation();
        modelOperation.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelOperation.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                modelOperation.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelOperation.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                modelOperation.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelOperation;
    }

    private ModelPermission parseModelPermission(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelPermission modelPermission = new ModelPermission();
        modelPermission.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelPermission.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                modelPermission.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelPermission.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                modelPermission.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("operation")) {
                if (parsed.contains("operation")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("operation");
                modelPermission.setOperation(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("resource")) {
                if (parsed.contains("resource")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("resource");
                modelPermission.setResource(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelPermission;
    }

    private ModelResource parseModelResource(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelResource modelResource = new ModelResource();
        modelResource.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelResource.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                modelResource.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                modelResource.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("pattern")) {
                if (parsed.contains("pattern")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("pattern");
                modelResource.setPattern(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "pattern", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelResource.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelResource;
    }

    private ModelRole parseModelRole(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelRole modelRole = new ModelRole();
        modelRole.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelRole.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                modelRole.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelRole.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("assignable")) {
                if (parsed.contains("assignable")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("assignable");
                modelRole.setAssignable(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "assignable", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                modelRole.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permissions")) {
                if (parsed.contains("permissions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permissions");
                ArrayList permissions = new ArrayList();
                modelRole.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("permission")) {
                        modelRole.addPermission(this.parseModelPermission("permission", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("parentRoles")) {
                if (parsed.contains("parentRoles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("parentRoles");
                ArrayList<String> parentRoles = new ArrayList<String>();
                modelRole.setParentRoles(parentRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("parentRole")) {
                        parentRoles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("childRoles")) {
                if (parsed.contains("childRoles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("childRoles");
                ArrayList<String> childRoles = new ArrayList<String>();
                modelRole.setChildRoles(childRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("childRole")) {
                        childRoles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelRole;
    }

    private ModelTemplate parseModelTemplate(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ModelTemplate modelTemplate = new ModelTemplate();
        modelTemplate.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                modelTemplate.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("namePrefix")) {
                if (parsed.contains("namePrefix")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("namePrefix");
                modelTemplate.setNamePrefix(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("delimiter")) {
                if (parsed.contains("delimiter")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("delimiter");
                modelTemplate.setDelimiter(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                modelTemplate.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("assignable")) {
                if (parsed.contains("assignable")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("assignable");
                modelTemplate.setAssignable(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "assignable", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanent")) {
                if (parsed.contains("permanent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanent");
                modelTemplate.setPermanent(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanent", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permanentResource")) {
                if (parsed.contains("permanentResource")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permanentResource");
                modelTemplate.setPermanentResource(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "permanentResource", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("permissions")) {
                if (parsed.contains("permissions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("permissions");
                ArrayList permissions = new ArrayList();
                modelTemplate.setPermissions(permissions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("permission")) {
                        modelTemplate.addPermission(this.parseModelPermission("permission", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("parentRoles")) {
                if (parsed.contains("parentRoles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("parentRoles");
                ArrayList<String> parentRoles = new ArrayList<String>();
                modelTemplate.setParentRoles(parentRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("parentRole")) {
                        parentRoles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("childRoles")) {
                if (parsed.contains("childRoles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("childRoles");
                ArrayList<String> childRoles = new ArrayList<String>();
                modelTemplate.setChildRoles(childRoles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("childRole")) {
                        childRoles.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("parentTemplates")) {
                if (parsed.contains("parentTemplates")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("parentTemplates");
                ArrayList<String> parentTemplates = new ArrayList<String>();
                modelTemplate.setParentTemplates(parentTemplates);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("parentTemplate")) {
                        parentTemplates.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("childTemplates")) {
                if (parsed.contains("childTemplates")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("childTemplates");
                ArrayList<String> childTemplates = new ArrayList<String>();
                modelTemplate.setChildTemplates(childTemplates);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("childTemplate")) {
                        childTemplates.add(this.getTrimmedValue(xmlStreamReader.getElementText()));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return modelTemplate;
    }

    private RedbackRoleModel parseRedbackRoleModel(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        RedbackRoleModel redbackRoleModel = new RedbackRoleModel();
        redbackRoleModel.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("modelVersion")) {
                if (parsed.contains("modelVersion")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("modelVersion");
                redbackRoleModel.setModelVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("applications")) {
                if (parsed.contains("applications")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("applications");
                ArrayList applications = new ArrayList();
                redbackRoleModel.setApplications(applications);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("application")) {
                        redbackRoleModel.addApplication(this.parseModelApplication("application", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return redbackRoleModel;
    }

    public RedbackRoleModel read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RedbackRoleModel value = this.parseRedbackRoleModel("redback-role-model", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public RedbackRoleModel read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public RedbackRoleModel read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        RedbackRoleModel value = this.parseRedbackRoleModel("redback-role-model", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public RedbackRoleModel read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(RedbackRoleModel value) {
    }
}

