/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.role.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelOperation;
import org.codehaus.plexus.redback.role.model.ModelPermission;
import org.codehaus.plexus.redback.role.model.ModelResource;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.redback.role.processor.RoleModelProcessor;
import org.codehaus.plexus.redback.role.util.RoleModelUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="roleModelProcessor")
public class DefaultRoleModelProcessor
implements RoleModelProcessor {
    private Logger log = LoggerFactory.getLogger(DefaultRoleModelProcessor.class);
    @Resource(name="rBACManager#cached")
    private RBACManager rbacManager;
    private Map<String, org.codehaus.plexus.redback.rbac.Resource> resourceMap = new HashMap<String, org.codehaus.plexus.redback.rbac.Resource>();
    private Map<String, Operation> operationMap = new HashMap<String, Operation>();

    @Override
    public void process(RedbackRoleModel model) throws RoleManagerException {
        this.processResources(model);
        this.processOperations(model);
        this.processRoles(model);
    }

    private void processResources(RedbackRoleModel model) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelResource profileResource : application.getResources()) {
                try {
                    if (!this.rbacManager.resourceExists(profileResource.getName())) {
                        org.codehaus.plexus.redback.rbac.Resource resource = this.rbacManager.createResource(profileResource.getName());
                        resource.setPermanent(profileResource.isPermanent());
                        resource = this.rbacManager.saveResource(resource);
                        this.resourceMap.put(profileResource.getId(), resource);
                        continue;
                    }
                    this.resourceMap.put(profileResource.getId(), this.rbacManager.getResource(profileResource.getName()));
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating resource '" + profileResource.getName() + "'", e);
                }
            }
        }
    }

    private void processOperations(RedbackRoleModel model) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelOperation profileOperation : application.getOperations()) {
                try {
                    if (!this.rbacManager.operationExists(profileOperation.getName())) {
                        Operation operation = this.rbacManager.createOperation(profileOperation.getName());
                        operation.setPermanent(profileOperation.isPermanent());
                        operation.setDescription(profileOperation.getDescription());
                        operation = this.rbacManager.saveOperation(operation);
                        this.operationMap.put(profileOperation.getId(), operation);
                        continue;
                    }
                    this.operationMap.put(profileOperation.getId(), this.rbacManager.getOperation(profileOperation.getName()));
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating operation '" + profileOperation.getName() + "'", e);
                }
            }
        }
    }

    private void processRoles(RedbackRoleModel model) throws RoleManagerException {
        List<String> sortedGraph;
        try {
            sortedGraph = RoleModelUtils.reverseTopologicalSortedRoleList(model);
        }
        catch (CycleDetectedException e) {
            throw new RoleManagerException("cycle detected: this should have been caught in validation", e);
        }
        for (String roleId : sortedGraph) {
            Role role;
            ModelRole roleProfile = RoleModelUtils.getModelRole(model, roleId);
            List<Permission> permissions = this.processPermissions(roleProfile.getPermissions());
            if (!this.rbacManager.roleExists(roleProfile.getName())) {
                try {
                    role = this.rbacManager.createRole(roleProfile.getName());
                    role.setDescription(roleProfile.getDescription());
                    role.setPermanent(roleProfile.isPermanent());
                    role.setAssignable(roleProfile.isAssignable());
                    for (Permission permission : permissions) {
                        role.addPermission(permission);
                    }
                    if (roleProfile.getChildRoles() != null) {
                        for (String childRoleId : roleProfile.getChildRoles()) {
                            ModelRole childRoleProfile = RoleModelUtils.getModelRole(model, childRoleId);
                            role.addChildRoleName(childRoleProfile.getName());
                        }
                    }
                    this.rbacManager.saveRole(role);
                    if (roleProfile.getParentRoles() == null) continue;
                    for (String parentRoleId : roleProfile.getParentRoles()) {
                        ModelRole parentModelRole = RoleModelUtils.getModelRole(model, parentRoleId);
                        Role parentRole = this.rbacManager.getRole(parentModelRole.getName());
                        parentRole.addChildRoleName(role.getName());
                        this.rbacManager.saveRole(parentRole);
                    }
                    continue;
                }
                catch (RbacManagerException e) {
                    throw new RoleManagerException("error creating role '" + roleProfile.getName() + "'", e);
                }
            }
            try {
                role = this.rbacManager.getRole(roleProfile.getName());
                boolean changed = false;
                for (Permission permission : permissions) {
                    if (role.getPermissions().contains(permission)) continue;
                    this.log.info("Adding new permission '" + permission.getName() + "' to role '" + role.getName() + "'");
                    role.addPermission(permission);
                    changed = true;
                }
                ArrayList oldPermissions = new ArrayList(role.getPermissions());
                for (Permission permission : oldPermissions) {
                    if (permissions.contains(permission)) continue;
                    this.log.info("Removing old permission '" + permission.getName() + "' from role '" + role.getName() + "'");
                    role.removePermission(permission);
                    changed = true;
                }
                if (!changed) continue;
                this.rbacManager.saveRole(role);
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error updating role '" + roleProfile.getName() + "'", e);
            }
        }
    }

    private List<Permission> processPermissions(List<ModelPermission> permissions) throws RoleManagerException {
        ArrayList<Permission> rbacPermissions = new ArrayList<Permission>();
        for (ModelPermission profilePermission : permissions) {
            try {
                if (!this.rbacManager.permissionExists(profilePermission.getName())) {
                    Permission permission = this.rbacManager.createPermission(profilePermission.getName());
                    Operation operation = this.operationMap.get(profilePermission.getOperation());
                    org.codehaus.plexus.redback.rbac.Resource resource = this.resourceMap.get(profilePermission.getResource());
                    permission.setOperation(operation);
                    permission.setResource(resource);
                    permission.setPermanent(profilePermission.isPermanent());
                    permission.setDescription(profilePermission.getDescription());
                    permission = this.rbacManager.savePermission(permission);
                    rbacPermissions.add(permission);
                    continue;
                }
                rbacPermissions.add(this.rbacManager.getPermission(profilePermission.getName()));
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error creating permission '" + profilePermission.getName() + "'", e);
            }
        }
        return rbacPermissions;
    }
}

