/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.role.template;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.rbac.Operation;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelOperation;
import org.codehaus.plexus.redback.role.model.ModelPermission;
import org.codehaus.plexus.redback.role.model.ModelResource;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.ModelTemplate;
import org.codehaus.plexus.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.redback.role.template.RoleTemplateProcessor;
import org.codehaus.plexus.redback.role.template.RoleTemplateProcessorException;
import org.codehaus.plexus.redback.role.util.RoleModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="roleTemplateProcessor")
public class DefaultRoleTemplateProcessor
implements RoleTemplateProcessor {
    private Logger log = LoggerFactory.getLogger(DefaultRoleTemplateProcessor.class);
    @Resource(name="rBACManager#cached")
    private RBACManager rbacManager;

    @Override
    public void create(RedbackRoleModel model, String templateId, String resource) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                if (!templateId.equals(template.getId())) continue;
                this.processResource(template, resource);
                this.processTemplate(model, template, resource);
                return;
            }
        }
        throw new RoleManagerException("unknown template '" + templateId + "'");
    }

    @Override
    public void remove(RedbackRoleModel model, String templateId, String resource) throws RoleManagerException {
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                if (!templateId.equals(template.getId())) continue;
                this.removeTemplatedRole(model, template, resource);
                return;
            }
        }
        throw new RoleManagerException("unknown template '" + templateId + "'");
    }

    private void removeTemplatedRole(RedbackRoleModel model, ModelTemplate template, String resource) throws RoleManagerException {
        block3: {
            String roleName = template.getNamePrefix() + template.getDelimiter() + resource;
            try {
                Role role = this.rbacManager.getRole(roleName);
                if (!role.isPermanent()) {
                    this.rbacManager.removeRole(role);
                    org.codehaus.plexus.redback.rbac.Resource rbacResource = this.rbacManager.getResource(resource);
                    if (rbacResource.isPermanent()) break block3;
                }
                throw new RoleManagerException("unable to remove role, it is flagged permanent");
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("unable to remove templated role: " + roleName, e);
            }
        }
    }

    private void processResource(ModelTemplate template, String resource) throws RoleManagerException {
        if (!this.rbacManager.resourceExists(resource)) {
            try {
                org.codehaus.plexus.redback.rbac.Resource res = this.rbacManager.createResource(resource);
                res.setPermanent(template.isPermanentResource());
                this.rbacManager.saveResource(res);
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error creating resource '" + resource + "'", e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processTemplate(RedbackRoleModel model, ModelTemplate template, String resource) throws RoleManagerException {
        String templateName = template.getNamePrefix() + template.getDelimiter() + resource;
        List<Permission> permissions = this.processPermissions(model, template, resource);
        if (!this.rbacManager.roleExists(templateName)) {
            try {
                Role role = this.rbacManager.createRole(templateName);
                role.setDescription(template.getDescription());
                role.setPermanent(template.isPermanent());
                role.setAssignable(template.isAssignable());
                for (Permission permission : permissions) {
                    role.addPermission(permission);
                }
                if (template.getChildRoles() != null) {
                    for (String childRoleId : template.getChildRoles()) {
                        ModelRole childRoleProfile = RoleModelUtils.getModelRole(model, childRoleId);
                        role.addChildRoleName(childRoleProfile.getName());
                    }
                }
                if (template.getChildTemplates() != null) {
                    for (String childTemplateId : template.getChildTemplates()) {
                        ModelTemplate childModelTemplate = RoleModelUtils.getModelTemplate(model, childTemplateId);
                        if (childModelTemplate == null) {
                            throw new RoleManagerException("error obtaining child template from model: template " + templateName + " # child template: " + childTemplateId);
                        }
                        String childRoleName = childModelTemplate.getNamePrefix() + childModelTemplate.getDelimiter() + resource;
                        if (this.rbacManager.roleExists(childRoleName)) {
                            role.addChildRoleName(childRoleName);
                            continue;
                        }
                        this.processTemplate(model, childModelTemplate, resource);
                        role.addChildRoleName(childRoleName);
                    }
                }
                if (!this.rbacManager.roleExists(role.getName())) {
                    role = this.rbacManager.saveRole(role);
                }
                if (template.getParentRoles() != null) {
                    for (String parentRoleId : template.getParentRoles()) {
                        ModelRole parentModelRole = RoleModelUtils.getModelRole(model, parentRoleId);
                        Role parentRole = this.rbacManager.getRole(parentModelRole.getName());
                        parentRole.addChildRoleName(role.getName());
                        this.rbacManager.saveRole(parentRole);
                    }
                }
                if (template.getParentTemplates() == null) return;
                for (String parentTemplateId : template.getParentTemplates()) {
                    Role parentRole;
                    ModelTemplate parentModelTemplate = RoleModelUtils.getModelTemplate(model, parentTemplateId);
                    if (parentModelTemplate == null) {
                        throw new RoleManagerException("error obtaining parent template from model: template " + templateName + " # child template: " + parentTemplateId);
                    }
                    String parentRoleName = parentModelTemplate.getNamePrefix() + parentModelTemplate.getDelimiter() + resource;
                    if (this.rbacManager.roleExists(parentRoleName)) {
                        parentRole = this.rbacManager.getRole(parentRoleName);
                        parentRole.addChildRoleName(role.getName());
                        this.rbacManager.saveRole(parentRole);
                        continue;
                    }
                    this.processTemplate(model, parentModelTemplate, resource);
                    parentRole = this.rbacManager.getRole(parentRoleName);
                    parentRole.addChildRoleName(role.getName());
                    this.rbacManager.saveRole(parentRole);
                }
                return;
            }
            catch (RbacManagerException e) {
                throw new RoleManagerException("error creating role '" + templateName + "'", e);
            }
        }
        try {
            Role role = this.rbacManager.getRole(templateName);
            boolean changed = false;
            for (Permission permission : permissions) {
                if (role.getPermissions().contains(permission)) continue;
                this.log.info("Adding new permission '" + permission.getName() + "' to role '" + role.getName() + "'");
                role.addPermission(permission);
                changed = true;
            }
            ArrayList oldPermissions = new ArrayList(role.getPermissions());
            for (Permission permission : oldPermissions) {
                if (permissions.contains(permission)) continue;
                this.log.info("Removing old permission '" + permission.getName() + "' from role '" + role.getName() + "'");
                role.removePermission(permission);
                changed = true;
            }
            if (!changed) return;
            this.rbacManager.saveRole(role);
            return;
        }
        catch (RbacManagerException e) {
            throw new RoleManagerException("error updating role '" + templateName + "'", e);
        }
    }

    private List<Permission> processPermissions(RedbackRoleModel model, ModelTemplate template, String resource) throws RoleManagerException {
        ArrayList<Permission> rbacPermissions = new ArrayList<Permission>();
        if (template.getPermissions() != null) {
            ArrayList templatePermissions = new ArrayList(template.getPermissions());
            for (ModelPermission profilePermission : templatePermissions) {
                try {
                    String permissionName = profilePermission.getName() + template.getDelimiter() + this.resolvePermissionResource(model, profilePermission, resource);
                    if (!this.rbacManager.permissionExists(permissionName)) {
                        Permission permission = this.rbacManager.createPermission(permissionName);
                        ModelOperation modelOperation = RoleModelUtils.getModelOperation(model, profilePermission.getOperation());
                        Operation rbacOperation = this.rbacManager.getOperation(modelOperation.getName());
                        String permissionResource = this.resolvePermissionResource(model, profilePermission, resource);
                        org.codehaus.plexus.redback.rbac.Resource rbacResource = this.rbacManager.getResource(permissionResource);
                        permission.setOperation(rbacOperation);
                        permission.setResource(rbacResource);
                        permission.setPermanent(profilePermission.isPermanent());
                        permission.setDescription(profilePermission.getDescription());
                        permission = this.rbacManager.savePermission(permission);
                        rbacPermissions.add(permission);
                        continue;
                    }
                    rbacPermissions.add(this.rbacManager.getPermission(permissionName));
                }
                catch (RbacManagerException e) {
                    e.printStackTrace();
                    throw new RoleManagerException("unable to generate templated role: " + e.getMessage(), e);
                }
                catch (RoleTemplateProcessorException e) {
                    e.printStackTrace();
                    throw new RoleManagerException("unable to resolve resource: " + resource, e);
                }
            }
        }
        return rbacPermissions;
    }

    private String resolvePermissionResource(RedbackRoleModel model, ModelPermission permission, String resource) throws RoleTemplateProcessorException {
        String tempStr;
        String permissionResource = permission.getResource();
        if (permissionResource.startsWith("${") && "resource".equals(tempStr = permissionResource.substring(2, permissionResource.indexOf(125)))) {
            return resource;
        }
        String declaredResource = this.resolveResource(model, permission.getResource());
        if (declaredResource != null) {
            return declaredResource;
        }
        return resource;
    }

    private String resolveResource(RedbackRoleModel model, String resource) throws RoleTemplateProcessorException {
        ModelResource resolvedResource = RoleModelUtils.getModelResource(model, resource);
        if (resolvedResource != null) {
            return resolvedResource.getName();
        }
        return null;
    }
}

