/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.role.validator;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.role.model.ModelApplication;
import org.codehaus.plexus.redback.role.model.ModelOperation;
import org.codehaus.plexus.redback.role.model.ModelPermission;
import org.codehaus.plexus.redback.role.model.ModelResource;
import org.codehaus.plexus.redback.role.model.ModelRole;
import org.codehaus.plexus.redback.role.model.ModelTemplate;
import org.codehaus.plexus.redback.role.model.RedbackRoleModel;
import org.codehaus.plexus.redback.role.util.RoleModelUtils;
import org.codehaus.plexus.redback.role.validator.RoleModelValidator;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="roleModelValidator")
public class DefaultRoleModelValidator
implements RoleModelValidator {
    private List<String> validationErrors;

    @Override
    public boolean validate(RedbackRoleModel model) throws RoleManagerException {
        this.validationErrors = null;
        this.validateRequiredStructure(model);
        this.validateResourceClosure(model);
        this.validateOperationClosure(model);
        this.validateChildRoleClosure(model);
        this.validateParentRoleClosure(model);
        this.validateTemplateClosure(model);
        this.validateNoRoleCycles(model);
        this.validateNoTemplateCycles(model);
        return this.validationErrors == null;
    }

    @Override
    public List<String> getValidationErrors() {
        return this.validationErrors;
    }

    private void addValidationError(String error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<String>();
        }
        this.validationErrors.add(error);
    }

    private void validateRequiredStructure(RedbackRoleModel model) {
        for (ModelApplication application : model.getApplications()) {
            if (application.getId() == null) {
                this.addValidationError("model is missing application name");
            }
            if (application.getVersion() == null) {
                this.addValidationError(application.getId() + " is missing version");
            }
            for (ModelResource resource : application.getResources()) {
                if (resource.getName() == null) {
                    this.addValidationError(resource.toString() + " missing name");
                }
                if (resource.getId() != null) continue;
                this.addValidationError(resource.toString() + " missing id");
            }
            for (ModelOperation operation : application.getOperations()) {
                if (operation.getName() == null) {
                    this.addValidationError(operation.toString() + " missing name");
                }
                if (operation.getId() != null) continue;
                this.addValidationError(operation.toString() + " missing id");
            }
            for (ModelRole role : application.getRoles()) {
                if (role.getId() == null) {
                    this.addValidationError(role.toString() + " missing id");
                }
                if (role.getName() == null) {
                    this.addValidationError(role.toString() + " missing name");
                }
                if (role.getPermissions() == null) continue;
                for (ModelPermission permission : role.getPermissions()) {
                    if (permission.getName() == null) {
                        this.addValidationError(permission.toString() + " missing name");
                    }
                    if (permission.getId() == null) {
                        this.addValidationError(permission.toString() + " missing id");
                    }
                    if (permission.getOperation() == null) {
                        this.addValidationError(permission.toString() + " missing operations");
                    }
                    if (permission.getResource() != null) continue;
                    this.addValidationError(permission.toString() + " missing resource");
                }
            }
            for (ModelTemplate template : application.getTemplates()) {
                if (template.getId() == null) {
                    this.addValidationError(template.toString() + " missing id");
                }
                if (template.getNamePrefix() == null) {
                    this.addValidationError(template.toString() + " missing name prefix");
                }
                if (template.getPermissions() == null) continue;
                for (ModelPermission permission : template.getPermissions()) {
                    if (permission.getName() == null) {
                        this.addValidationError(permission.toString() + " missing name");
                    }
                    if (permission.getId() == null) {
                        this.addValidationError(permission.toString() + " missing id");
                    }
                    if (permission.getOperation() == null) {
                        this.addValidationError(permission.toString() + " missing operations");
                    }
                    if (permission.getResource() != null) continue;
                    this.addValidationError(permission.toString() + " missing resource");
                }
            }
        }
    }

    private void validateOperationClosure(RedbackRoleModel model) {
        List<String> operationIdList = RoleModelUtils.getOperationIdList(model);
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                if (role.getPermissions() == null) continue;
                for (ModelPermission permission : role.getPermissions()) {
                    if (operationIdList.contains(permission.getOperation())) continue;
                    this.addValidationError("missing operation: " + permission.getOperation() + " in permission " + permission.getId());
                }
            }
            for (ModelTemplate template : application.getTemplates()) {
                if (template.getPermissions() == null) continue;
                for (ModelPermission permission : template.getPermissions()) {
                    if (operationIdList.contains(permission.getOperation())) continue;
                    this.addValidationError("missing operation: " + permission.getOperation() + " in permission " + permission.getId());
                }
            }
        }
    }

    private void validateResourceClosure(RedbackRoleModel model) {
        List<String> resourceIdList = RoleModelUtils.getResourceIdList(model);
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                if (role.getPermissions() == null) continue;
                for (ModelPermission permission : role.getPermissions()) {
                    if (resourceIdList.contains(permission.getResource())) continue;
                    this.addValidationError("missing operation: " + permission.getResource() + " in permission " + permission.getId());
                }
            }
        }
    }

    private void validateChildRoleClosure(RedbackRoleModel model) {
        List<String> roleIdList = RoleModelUtils.getRoleIdList(model);
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                if (role.getChildRoles() == null) continue;
                for (String childRoleId : role.getChildRoles()) {
                    if (roleIdList.contains(childRoleId)) continue;
                    this.addValidationError("missing role id: " + childRoleId + " in child roles of role " + role.getId());
                }
            }
            for (ModelTemplate template : application.getTemplates()) {
                if (template.getChildRoles() == null) continue;
                for (String childRoleId : template.getChildRoles()) {
                    if (roleIdList.contains(childRoleId)) continue;
                    this.addValidationError("missing role id: " + childRoleId + " in child roles of template " + template.getId());
                }
            }
        }
    }

    private void validateParentRoleClosure(RedbackRoleModel model) {
        List<String> roleIdList = RoleModelUtils.getRoleIdList(model);
        for (ModelApplication application : model.getApplications()) {
            for (ModelRole role : application.getRoles()) {
                if (role.getParentRoles() == null) continue;
                for (String parentRoleId : role.getParentRoles()) {
                    if (roleIdList.contains(parentRoleId)) continue;
                    this.addValidationError("missing role id: " + parentRoleId + " in parent roles of role " + role.getId());
                }
            }
            for (ModelTemplate template : application.getTemplates()) {
                if (template.getParentRoles() == null) continue;
                for (String parentRoleId : template.getParentRoles()) {
                    if (roleIdList.contains(parentRoleId)) continue;
                    this.addValidationError("missing role id: " + parentRoleId + " in parent roles of template " + template.getId());
                }
            }
        }
    }

    private void validateTemplateClosure(RedbackRoleModel model) {
        List<String> templateIdList = RoleModelUtils.getTemplateIdList(model);
        ArrayList<String> templateNamePrefixList = new ArrayList<String>();
        for (ModelApplication application : model.getApplications()) {
            for (ModelTemplate template : application.getTemplates()) {
                if (template.getParentTemplates() != null) {
                    for (String parentTemplateId : template.getParentTemplates()) {
                        if (templateIdList.contains(parentTemplateId)) continue;
                        this.addValidationError("missing template id: " + parentTemplateId + " in parent templates of template " + template.getId());
                    }
                }
                if (template.getChildTemplates() != null) {
                    for (String childTemplateId : template.getChildTemplates()) {
                        if (templateIdList.contains(childTemplateId)) continue;
                        this.addValidationError("missing template id: " + childTemplateId + " in child templates of template " + template.getId());
                    }
                }
                if (!templateNamePrefixList.contains(template.getNamePrefix())) {
                    templateNamePrefixList.add(template.getNamePrefix());
                    continue;
                }
                this.addValidationError("duplicate name prefix detected: " + template.getNamePrefix());
            }
        }
    }

    private void validateNoRoleCycles(RedbackRoleModel model) {
        try {
            RoleModelUtils.generateRoleGraph(model);
        }
        catch (CycleDetectedException e) {
            this.addValidationError("cycle detected: " + e.getMessage());
        }
    }

    private void validateNoTemplateCycles(RedbackRoleModel model) {
        try {
            RoleModelUtils.generateTemplateGraph(model);
        }
        catch (CycleDetectedException e) {
            this.addValidationError("template cycle detected: " + e.getMessage());
        }
    }
}

