/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.struts2.action.RedbackActionSupport;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.redback.integration.interceptor.SecureAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public abstract class AbstractSecurityAction
extends RedbackActionSupport
implements SecureAction {
    protected static final String REQUIRES_AUTHENTICATION = "requires-authentication";
    private SecureActionBundle securityBundle;

    public SecureActionBundle getSecureActionBundle() throws SecureActionException {
        if (this.securityBundle == null) {
            this.securityBundle = this.initSecureActionBundle();
        }
        return this.securityBundle;
    }

    public abstract SecureActionBundle initSecureActionBundle() throws SecureActionException;

    protected void setAuthTokens(SecuritySession securitySession) {
        this.session.put("securitySession", securitySession);
        this.setSession(this.session);
    }

    protected SecuritySession getSecuritySession() {
        return (SecuritySession)this.session.get("securitySession");
    }

    protected void processPasswordRuleViolations(PasswordRuleViolationException e) {
        this.processPasswordRuleViolations(e, "user.password");
    }

    protected void processPasswordRuleViolations(PasswordRuleViolationException e, String field) {
        PasswordRuleViolations violations = e.getViolations();
        if (violations != null) {
            for (String violation : violations.getLocalizedViolations()) {
                this.addFieldError(field, violation);
            }
        }
    }

    protected String getBaseUrl() {
        HttpServletRequest req = ServletActionContext.getRequest();
        return req.getScheme() + "://" + req.getServerName() + (req.getServerPort() == 80 ? "" : ":" + req.getServerPort()) + req.getContextPath();
    }

    protected String getCurrentUser() {
        SecuritySession securitySession = this.getSecuritySession();
        if (securitySession != null && securitySession.getUser() != null) {
            return securitySession.getUser().getPrincipal().toString();
        }
        return null;
    }
}

