/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.rbac.Permission;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.model.UserCredentials;
import org.codehaus.redback.integration.util.RoleSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserCredentialsAction
extends AbstractSecurityAction {
    private RBACManager manager;
    protected SecuritySystem securitySystem;
    protected UserCredentials internalUser;
    protected final String VALID_USERNAME_CHARS = "[a-zA-Z_0-9\\-.@]*";

    public RBACManager getManager() {
        return this.manager;
    }

    public void setManager(RBACManager manager) {
        this.manager = manager;
    }

    public SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    public void setSecuritySystem(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    public void validateCredentialsLoose() {
        if (StringUtils.isEmpty((String)this.internalUser.getUsername())) {
            this.addFieldError("user.username", this.getText("username.required"));
        } else if (!this.internalUser.getUsername().matches("[a-zA-Z_0-9\\-.@]*")) {
            this.addFieldError("user.username", this.getText("username.invalid.characters"));
        }
        if (StringUtils.isEmpty((String)this.internalUser.getFullName())) {
            this.addFieldError("user.fullName", this.getText("fullName.required"));
        }
        if (StringUtils.isEmpty((String)this.internalUser.getEmail())) {
            this.addFieldError("user.email", this.getText("email.required"));
        }
        if (!StringUtils.equals((String)this.internalUser.getPassword(), (String)this.internalUser.getConfirmPassword())) {
            this.addFieldError("user.confirmPassword", this.getText("passwords.does.not.match"));
        }
        try {
            if (!StringUtils.isEmpty((String)this.internalUser.getEmail())) {
                new InternetAddress(this.internalUser.getEmail(), true);
            }
        }
        catch (AddressException e) {
            this.addFieldError("user.email", this.getText("email.invalid"));
        }
    }

    public void validateCredentialsStrict() {
        this.validateCredentialsLoose();
        User tmpuser = this.internalUser.createUser(this.securitySystem.getUserManager());
        try {
            this.securitySystem.getPolicy().validatePassword(tmpuser);
        }
        catch (PasswordRuleViolationException e) {
            this.processPasswordRuleViolations(e);
        }
        if (StringUtils.isEmpty((String)this.internalUser.getPassword())) {
            this.addFieldError("user.password", this.getText("password.required"));
        }
    }

    protected List<Role> filterRolesForCurrentUserAccess(List<Role> roleList) throws RbacManagerException {
        String currentUser = this.getCurrentUser();
        ArrayList<Role> filteredRoleList = new ArrayList<Role>();
        Map assignedPermissionMap = this.manager.getAssignedPermissionMap(currentUser);
        ArrayList<String> resourceGrants = new ArrayList<String>();
        if (assignedPermissionMap.containsKey("user-management-role-grant")) {
            List roleGrantPermissions = (List)assignedPermissionMap.get("user-management-role-grant");
            for (Permission permission : roleGrantPermissions) {
                if (permission.getResource().getIdentifier().equals("*")) {
                    return roleList;
                }
                resourceGrants.add(permission.getResource().getIdentifier());
            }
        } else {
            return Collections.emptyList();
        }
        String delimiter = " - ";
        for (Role role : roleList) {
            int delimiterIndex = role.getName().indexOf(delimiter);
            for (String resourceIdentifier : resourceGrants) {
                String resourceName;
                if (role.getName().indexOf(resourceIdentifier) == -1 || delimiterIndex == -1 || !(resourceName = role.getName().substring(delimiterIndex + delimiter.length())).equals(resourceIdentifier)) continue;
                filteredRoleList.add(role);
            }
        }
        Collections.sort(filteredRoleList, new RoleSorter());
        return filteredRoleList;
    }

    protected List<Role> getFilteredRolesForCurrentUserAccess() throws RbacManagerException {
        List roles = this.manager.getAllRoles();
        if (roles == null) {
            return Collections.emptyList();
        }
        return this.filterRolesForCurrentUserAccess(roles);
    }
}

