/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.Arrays;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.EditUserCredentials;

public class AccountAction
extends AbstractUserCredentialsAction
implements CancellableAction {
    private static final String ACCOUNT_SUCCESS = "security-account-success";
    private EditUserCredentials user;
    private String oldPassword;

    public String show() {
        SecuritySession session = this.getSecuritySession();
        if (!session.isAuthenticated()) {
            this.addActionError(this.getText("cannot.show.account.login.required"));
            return "requires-authentication";
        }
        String username = session.getUser().getUsername();
        if (username == null) {
            this.addActionError(this.getText("cannot.edit.user.null.username"));
            return "error";
        }
        if (StringUtils.isEmpty((String)username)) {
            this.addActionError(this.getText("cannot.edit.user.empty.username"));
            return "error";
        }
        UserManager manager = this.securitySystem.getUserManager();
        if (!manager.userExists((Object)username)) {
            this.addActionError(this.getText("user.does.not.exist", Arrays.asList(username)));
            return "error";
        }
        this.internalUser = this.user;
        try {
            User u = manager.findUser(username);
            if (u == null) {
                this.addActionError(this.getText("cannot.operate.on.null.user"));
                return "error";
            }
            this.user = new EditUserCredentials(u);
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.get.user", Arrays.asList(username, e.getMessage())));
            return "error";
        }
        return "input";
    }

    public String submit() {
        SecuritySession session = this.getSecuritySession();
        if (!session.isAuthenticated()) {
            this.addActionError(this.getText("cannot.show.account.login.required"));
            return "requires-authentication";
        }
        String username = session.getUser().getUsername();
        if (username == null) {
            this.addActionError(this.getText("cannot.edit.user.null.username"));
            return "error";
        }
        if (StringUtils.isEmpty((String)username)) {
            this.addActionError(this.getText("cannot.edit.user.empty.username"));
            return "error";
        }
        if (this.user == null) {
            this.addActionError(this.getText("cannot.edit.user.null.credentials"));
            return "error";
        }
        if (!this.user.getPassword().equals(this.user.getConfirmPassword())) {
            this.addFieldError("user.confirmPassword", this.getText("password.confimation.failed"));
            return "error";
        }
        UserManager manager = this.securitySystem.getUserManager();
        if (!manager.userExists((Object)username)) {
            this.addActionError(this.getText("user.does.not.exist", Arrays.asList(username)));
            return "error";
        }
        this.internalUser = this.user;
        try {
            User u = manager.findUser(username);
            if (u == null) {
                this.addActionError(this.getText("cannot.operate.on.null.user"));
                return "error";
            }
            if (StringUtils.isNotEmpty((String)this.user.getPassword())) {
                PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
                if (!encoder.isPasswordValid(u.getEncodedPassword(), this.oldPassword)) {
                    this.addFieldError("oldPassword", this.getText("password.provided.does.not.match.existing"));
                    return "error";
                }
                u.setPassword(this.user.getPassword());
            }
            u.setFullName(this.user.getFullName());
            u.setEmail(this.user.getEmail());
            u.setPassword(this.user.getPassword());
            manager.updateUser(u);
            if (this.getSecuritySession().getUser().getUsername().equals(u.getUsername())) {
                DefaultSecuritySession securitySession = new DefaultSecuritySession(this.getSecuritySession().getAuthenticationResult(), u);
                this.session.put("securitySession", securitySession);
                this.setSession(this.session);
            }
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.get.user", Arrays.asList(username, e.getMessage())));
            return "error";
        }
        catch (PasswordRuleViolationException e) {
            this.processPasswordRuleViolations(e);
            return "error";
        }
        return ACCOUNT_SUCCESS;
    }

    public String cancel() {
        return "cancel";
    }

    public EditUserCredentials getUser() {
        return this.user;
    }

    public void setUser(EditUserCredentials user) {
        this.user = user;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        return bundle;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public boolean isSelf() {
        return true;
    }
}

