/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.Arrays;
import java.util.Date;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.TokenBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.keys.KeyNotFoundException;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.util.AutoLoginCookies;

public class LoginAction
extends AbstractSecurityAction
implements CancellableAction {
    private static final String LOGIN_SUCCESS = "security-login-success";
    private static final String PASSWORD_CHANGE = "security-must-change-password";
    private static final String ACCOUNT_LOCKED = "security-login-locked";
    protected SecuritySystem securitySystem;
    private String username;
    private String password;
    private String validateMe;
    private String resetPassword;
    private boolean rememberMe;
    private AutoLoginCookies autologinCookies;
    private UserConfiguration config;

    public String show() {
        return "input";
    }

    public String login() {
        if (StringUtils.isNotEmpty((String)this.validateMe)) {
            return this.validated();
        }
        if (StringUtils.isNotEmpty((String)this.resetPassword)) {
            return this.resetPassword();
        }
        if (StringUtils.isEmpty((String)this.username)) {
            this.addFieldError("username", this.getText("username.required"));
            return "error";
        }
        PasswordBasedAuthenticationDataSource authdatasource = new PasswordBasedAuthenticationDataSource();
        authdatasource.setPrincipal(this.username);
        authdatasource.setPassword(this.password);
        return this.webLogin((AuthenticationDataSource)authdatasource, this.rememberMe);
    }

    public String resetPassword() {
        if (StringUtils.isEmpty((String)this.resetPassword)) {
            this.addActionError(this.getText("reset.password.missing"));
            return "error";
        }
        try {
            AuthenticationKey authkey = this.securitySystem.getKeyManager().findKey(this.resetPassword);
            User user = this.securitySystem.getUserManager().findUser(authkey.getForPrincipal());
            user.setPasswordChangeRequired(true);
            user.setEncodedPassword("");
            TokenBasedAuthenticationDataSource authsource = new TokenBasedAuthenticationDataSource();
            authsource.setPrincipal(user.getPrincipal().toString());
            authsource.setToken(authkey.getKey());
            authsource.setEnforcePasswordChange(false);
            this.securitySystem.getUserManager().updateUser(user);
            AuditEvent event = new AuditEvent(this.getText("log.password.change"));
            event.setAffectedUser(this.username);
            event.log();
            return this.webLogin((AuthenticationDataSource)authsource, false);
        }
        catch (KeyNotFoundException e) {
            this.log.info("Invalid key requested: " + this.resetPassword);
            this.addActionError(this.getText("cannot.find.key"));
            return "error";
        }
        catch (KeyManagerException e) {
            this.addActionError(this.getText("cannot.find.key.at.the.moment"));
            this.log.warn("Key Manager error: ", (Throwable)e);
            return "error";
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.find.user"));
            return "error";
        }
    }

    public String validated() {
        if (StringUtils.isEmpty((String)this.validateMe)) {
            this.addActionError(this.getText("validation.failure.key.missing"));
            return "error";
        }
        try {
            AuthenticationKey authkey = this.securitySystem.getKeyManager().findKey(this.validateMe);
            User user = this.securitySystem.getUserManager().findUser(authkey.getForPrincipal());
            user.setValidated(true);
            user.setLocked(false);
            user.setPasswordChangeRequired(true);
            user.setEncodedPassword("");
            TokenBasedAuthenticationDataSource authsource = new TokenBasedAuthenticationDataSource();
            authsource.setPrincipal(user.getPrincipal().toString());
            authsource.setToken(authkey.getKey());
            authsource.setEnforcePasswordChange(false);
            this.securitySystem.getUserManager().updateUser(user);
            String currentUser = this.getCurrentUser();
            AuditEvent event = new AuditEvent(this.getText("log.account.validation"));
            event.setAffectedUser(this.username);
            event.setCurrentUser(currentUser);
            event.log();
            return this.webLogin((AuthenticationDataSource)authsource, false);
        }
        catch (KeyNotFoundException e) {
            this.log.info("Invalid key requested: " + this.validateMe);
            this.addActionError(this.getText("cannot.find.key"));
            return "error";
        }
        catch (KeyManagerException e) {
            this.addActionError(this.getText("cannot.find.key.at.the.momment"));
            return "error";
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.find.user"));
            return "error";
        }
    }

    public String cancel() {
        return "cancel";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getValidateMe() {
        return this.validateMe;
    }

    public void setValidateMe(String validateMe) {
        this.validateMe = validateMe;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.OPEN;
    }

    public String getResetPassword() {
        return this.resetPassword;
    }

    public void setResetPassword(String resetPassword) {
        this.resetPassword = resetPassword;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    private String webLogin(AuthenticationDataSource authdatasource, boolean rememberMe) {
        this.setAuthTokens(null);
        this.clearErrorsAndMessages();
        try {
            SecuritySession securitySession = this.securitySystem.authenticate(authdatasource);
            if (securitySession.getAuthenticationResult().isAuthenticated()) {
                this.setAuthTokens(securitySession);
                if (this.securitySystem.getPolicy().getUserValidationSettings().isEmailValidationRequired() && !securitySession.getUser().getUsername().equals(this.config.getString("redback.default.admin")) && !securitySession.getUser().isValidated()) {
                    this.setAuthTokens(null);
                    this.addActionError(this.getText("account.validation.required"));
                    return "error";
                }
                this.setCookies(authdatasource, rememberMe);
                AuditEvent event = new AuditEvent(this.getText("log.login.success"));
                event.setAffectedUser(this.username);
                event.log();
                User user = securitySession.getUser();
                user.setLastLoginDate(new Date());
                this.securitySystem.getUserManager().updateUser(user);
                if (StringUtils.isNotEmpty((String)this.validateMe)) {
                    try {
                        this.securitySystem.getKeyManager().deleteKey(this.validateMe);
                    }
                    catch (KeyManagerException e) {
                        this.addActionError(this.getText("cannot.find.key.at.the.momment"));
                        return "error";
                    }
                }
                return LOGIN_SUCCESS;
            }
            this.log.debug("Login Action failed against principal : " + securitySession.getAuthenticationResult().getPrincipal(), (Throwable)securitySession.getAuthenticationResult().getException());
            AuthenticationResult result = securitySession.getAuthenticationResult();
            if (result.getExceptionsMap() != null && !result.getExceptionsMap().isEmpty()) {
                if (result.getExceptionsMap().get("1") != null) {
                    this.addActionError(this.getText("incorrect.username.password"));
                } else {
                    this.addActionError(this.getText("authentication.failed"));
                }
            } else {
                this.addActionError(this.getText("authentication.failed"));
            }
            AuditEvent event = new AuditEvent(this.getText("log.login.fail"));
            event.setAffectedUser(this.username);
            event.log();
            return "error";
        }
        catch (AuthenticationException ae) {
            this.addActionError(this.getText("authentication.exception", Arrays.asList(ae.getMessage())));
            return "error";
        }
        catch (UserNotFoundException ue) {
            this.addActionError(this.getText("user.not.found.exception", Arrays.asList(this.username, ue.getMessage())));
            AuditEvent event = new AuditEvent(this.getText("log.login.fail"));
            event.setAffectedUser(this.username);
            event.log();
            return "error";
        }
        catch (AccountLockedException e) {
            this.addActionError(this.getText("account.locked"));
            AuditEvent event = new AuditEvent(this.getText("log.login.fail.locked"));
            event.setAffectedUser(this.username);
            event.log();
            return ACCOUNT_LOCKED;
        }
        catch (MustChangePasswordException e) {
            this.setCookies(authdatasource, rememberMe);
            AuditEvent event = new AuditEvent(this.getText("log.login.fail.locked"));
            event.setAffectedUser(this.username);
            event.log();
            return PASSWORD_CHANGE;
        }
    }

    private void setCookies(AuthenticationDataSource authdatasource, boolean rememberMe) {
        if (rememberMe) {
            this.autologinCookies.setRememberMeCookie(authdatasource.getPrincipal(), ServletActionContext.getResponse(), ServletActionContext.getRequest());
        }
        this.autologinCookies.setSignonCookie(authdatasource.getPrincipal(), ServletActionContext.getResponse(), ServletActionContext.getRequest());
    }
}

