/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.Arrays;
import java.util.Map;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.policy.PasswordRuleViolations;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

public class PasswordAction
extends AbstractSecurityAction
implements CancellableAction {
    protected static final String CHANGE_PASSWORD_SUCCESS = "security-change-password-success";
    protected SecuritySystem securitySystem;
    private String existingPassword;
    private String newPassword;
    private String newPasswordConfirm;
    private String targetUrl;
    private boolean provideExisting;

    public String show() {
        this.provideExisting = StringUtils.isNotEmpty((String)this.getSecuritySession().getUser().getEncodedPassword());
        return "input";
    }

    public String submit() {
        PasswordRuleViolations violations;
        PasswordEncoder encoder;
        User user;
        SecuritySession securitySession;
        block17: {
            securitySession = this.getSecuritySession();
            this.provideExisting = StringUtils.isNotEmpty((String)securitySession.getUser().getEncodedPassword());
            if (StringUtils.isEmpty((String)this.newPassword)) {
                this.addFieldError("newPassword", this.getText("newPassword.cannot.be.empty"));
            }
            if (!StringUtils.equals((String)this.newPassword, (String)this.newPasswordConfirm)) {
                this.addFieldError("newPassword", this.getText("password.confimation.failed"));
            }
            user = securitySession.getUser();
            encoder = this.securitySystem.getPolicy().getPasswordEncoder();
            if (this.provideExisting && !encoder.isPasswordValid(user.getEncodedPassword(), this.existingPassword)) {
                this.addFieldError("existingPassword", this.getText("password.provided.does.not.match.existing"));
            }
            try {
                User tempUser = this.securitySystem.getUserManager().createUser("temp", "temp", "temp");
                tempUser.setPassword(this.newPassword);
                this.securitySystem.getPolicy().validatePassword(tempUser);
            }
            catch (PasswordRuleViolationException e) {
                violations = e.getViolations();
                if (violations == null) break block17;
                for (String violation : violations.getLocalizedViolations()) {
                    this.addFieldError("newPassword", violation);
                }
            }
        }
        if (this.hasActionErrors() || this.hasFieldErrors() || this.hasActionMessages()) {
            this.newPassword = "";
            this.newPasswordConfirm = "";
            this.existingPassword = "";
            return "error";
        }
        try {
            String encodedPassword = encoder.encodePassword(this.newPassword);
            user.setEncodedPassword(encodedPassword);
            user.setPassword(this.newPassword);
            this.securitySystem.getPolicy().validatePassword(user);
            this.securitySystem.getUserManager().updateUser(user);
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.update.user.not.found", Arrays.asList(user.getUsername())));
            this.addActionError(this.getText("admin.deleted.account"));
            return "error";
        }
        catch (PasswordRuleViolationException e) {
            violations = e.getViolations();
            if (violations != null) {
                for (String violation : violations.getLocalizedViolations()) {
                    this.addFieldError("newPassword", violation);
                }
            }
            if (!this.provideExisting) {
                user.setEncodedPassword("");
                user.setPassword("");
            }
            return "error";
        }
        this.log.info("Password Change Request Success.");
        String currentUser = this.getCurrentUser();
        AuditEvent event = new AuditEvent(this.getText("log.password.change"));
        event.setAffectedUser(user.getUsername());
        event.setCurrentUser(currentUser);
        event.log();
        if (!securitySession.isAuthenticated()) {
            this.log.debug("User is not authenticated.");
            return "requires-authentication";
        }
        if (!this.provideExisting) {
            return CHANGE_PASSWORD_SUCCESS;
        }
        if (this.session != null) {
            Map map = this.session;
            String url = "";
            if (!map.containsKey("targetUrl")) {
                this.log.info("targetUrl is empty, redirect to change password success page");
                return CHANGE_PASSWORD_SUCCESS;
            }
            url = map.remove("targetUrl").toString();
            this.log.info("targetUrl is retrieved and removed from the session: " + url);
            this.setTargetUrl(url);
        }
        return "success";
    }

    public String cancel() {
        return "cancel";
    }

    public String getExistingPassword() {
        return this.existingPassword;
    }

    public void setExistingPassword(String existingPassword) {
        this.existingPassword = existingPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirm() {
        return this.newPasswordConfirm;
    }

    public void setNewPasswordConfirm(String newPasswordConfirm) {
        this.newPasswordConfirm = newPasswordConfirm;
    }

    public boolean isProvideExisting() {
        return this.provideExisting;
    }

    public void setProvideExisting(boolean provideExisting) {
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.AUTHONLY;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }
}

