/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.Arrays;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.mail.Mailer;

public class PasswordResetAction
extends AbstractSecurityAction
implements CancellableAction {
    private Mailer mailer;
    private SecuritySystem securitySystem;
    private String username;

    public String show() {
        return "input";
    }

    public String reset() {
        if (StringUtils.isEmpty((String)this.username)) {
            this.addFieldError("username", this.getText("username.cannot.be.empty"));
            return "input";
        }
        UserManager userManager = this.securitySystem.getUserManager();
        KeyManager keyManager = this.securitySystem.getKeyManager();
        UserSecurityPolicy policy = this.securitySystem.getPolicy();
        try {
            User user = userManager.findUser(this.username);
            AuthenticationKey authkey = keyManager.createKey(this.username, "Password Reset Request", policy.getUserValidationSettings().getEmailValidationTimeout());
            this.mailer.sendPasswordResetEmail(Arrays.asList(user.getEmail()), authkey, this.getBaseUrl());
            AuditEvent event = new AuditEvent(this.getText("log.password.reset.request"));
            event.setAffectedUser(this.username);
            event.log();
            this.addActionMessage(this.getText("password.reset.success"));
        }
        catch (UserNotFoundException e) {
            this.addActionMessage(this.getText("password.reset.failure"));
            this.log.info("Password Reset on non-existant user [" + this.username + "].");
        }
        catch (KeyManagerException e) {
            this.addActionError(this.getText("password.reset.email.generation.failure"));
            this.log.info("Unable to issue password reset.", (Throwable)e);
        }
        return "input";
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.OPEN;
    }

    public String cancel() {
        return "none";
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

