/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action;

import java.util.Arrays;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.keys.KeyManagerException;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.mail.Mailer;
import org.codehaus.redback.integration.model.CreateUserCredentials;

public class RegisterAction
extends AbstractUserCredentialsAction
implements CancellableAction {
    protected static final String REGISTER_SUCCESS = "security-register-success";
    private static final String VALIDATION_NOTE = "validation-note";
    private static final String RESEND_VALIDATION_EMAIL = "security-resend-validation-email";
    private Mailer mailer;
    private RoleManager roleManager;
    private CreateUserCredentials user;
    private boolean emailValidationRequired;
    private String username;

    public String show() {
        if (this.user == null) {
            this.user = new CreateUserCredentials();
        }
        this.emailValidationRequired = this.securitySystem.getPolicy().getUserValidationSettings().isEmailValidationRequired();
        return "input";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String register() {
        if (this.user == null) {
            this.user = new CreateUserCredentials();
            this.addActionError(this.getText("invalid.user.credentials"));
            return "error";
        }
        UserSecurityPolicy securityPolicy = this.securitySystem.getPolicy();
        this.emailValidationRequired = securityPolicy.getUserValidationSettings().isEmailValidationRequired();
        this.internalUser = this.user;
        if (securityPolicy.getUserValidationSettings().isEmailValidationRequired()) {
            this.validateCredentialsLoose();
        } else {
            this.validateCredentialsStrict();
        }
        UserManager manager = this.securitySystem.getUserManager();
        if (manager.userExists((Object)this.user.getUsername())) {
            this.addActionError(this.getText("user.already.exists", Arrays.asList(this.user.getUsername())));
        }
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        User u = manager.createUser(this.user.getUsername(), this.user.getFullName(), this.user.getEmail());
        u.setPassword(this.user.getPassword());
        u.setValidated(false);
        u.setLocked(false);
        try {
            this.roleManager.assignRole("registered-user", u.getPrincipal().toString());
        }
        catch (RoleManagerException rpe) {
            this.addActionError(this.getText("assign.role.failure"));
            this.log.error("RoleProfile Error: " + rpe.getMessage(), (Throwable)rpe);
            return "error";
        }
        if (securityPolicy.getUserValidationSettings().isEmailValidationRequired()) {
            u.setLocked(true);
            try {
                AuthenticationKey authkey = this.securitySystem.getKeyManager().createKey(u.getPrincipal().toString(), "New User Email Validation", securityPolicy.getUserValidationSettings().getEmailValidationTimeout());
                this.mailer.sendAccountValidationEmail(Arrays.asList(u.getEmail()), authkey, this.getBaseUrl());
                securityPolicy.setEnabled(false);
                manager.addUser(u);
                String string = VALIDATION_NOTE;
                return string;
            }
            catch (KeyManagerException e) {
                this.addActionError(this.getText("cannot.register.user"));
                this.log.error("Unable to register a new user.", (Throwable)e);
                String string = "error";
                return string;
            }
            finally {
                securityPolicy.setEnabled(true);
            }
        }
        manager.addUser(u);
        AuditEvent event = new AuditEvent(this.getText("log.account.create"));
        event.setAffectedUser(this.username);
        event.log();
        return REGISTER_SUCCESS;
    }

    public String resendRegistrationEmail() {
        UserSecurityPolicy securityPolicy = this.securitySystem.getPolicy();
        try {
            User user = this.securitySystem.getUserManager().findUser(this.username);
            AuthenticationKey authkey = this.securitySystem.getKeyManager().createKey(user.getPrincipal().toString(), "New User Email Validation", securityPolicy.getUserValidationSettings().getEmailValidationTimeout());
            this.mailer.sendAccountValidationEmail(Arrays.asList(user.getEmail()), authkey, this.getBaseUrl());
            return RESEND_VALIDATION_EMAIL;
        }
        catch (KeyManagerException e) {
            this.addActionError(this.getText("cannot.register.user"));
            this.log.error("Unable to register a new user.", (Throwable)e);
            return "error";
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.find.user"));
            this.log.error("Unable to find user.", (Throwable)e);
            return "error";
        }
    }

    public String cancel() {
        return "cancel";
    }

    public CreateUserCredentials getUser() {
        return this.user;
    }

    public void setUser(CreateUserCredentials user) {
        this.user = user;
    }

    public boolean isEmailValidationRequired() {
        return this.emailValidationRequired;
    }

    public void setEmailValidationRequired(boolean emailValidationRequired) {
        this.emailValidationRequired = emailValidationRequired;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        return SecureActionBundle.OPEN;
    }
}

