/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.struts2.action.AbstractSecurityAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.reports.Report;
import org.codehaus.redback.integration.reports.ReportException;
import org.codehaus.redback.integration.reports.ReportManager;

public class ReportAction
extends AbstractSecurityAction {
    private ReportManager reportManager;
    private String reportId;
    private String reportType;

    public String generate() {
        Report report;
        try {
            report = this.reportManager.findReport(this.reportId, this.reportType);
        }
        catch (ReportException e) {
            this.addActionError(this.getText("cannot.get.report", Arrays.asList(e.getMessage())));
            return "error";
        }
        HttpServletResponse response = ServletActionContext.getResponse();
        if (response instanceof PageResponseWrapper) {
            response = (HttpServletResponse)((PageResponseWrapper)response).getResponse();
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            report.writeReport((OutputStream)os);
            response.reset();
            response.setContentType(report.getMimeType());
            response.addHeader("Content-Disposition", "attachment; filename=" + report.getId() + "." + report.getType());
            byte[] bytes = os.toByteArray();
            response.setContentLength(bytes.length);
            response.getOutputStream().write(bytes, 0, bytes.length);
            response.getOutputStream().flush();
            response.getOutputStream().close();
            return null;
        }
        catch (ReportException e) {
            String emsg = this.getText("cannot.generate.report");
            this.addActionError(emsg);
            this.log.error(emsg, (Throwable)e);
            return "error";
        }
        catch (IOException e) {
            String emsg = this.getText("cannot.generate.report");
            this.addActionError(emsg);
            this.log.error(emsg, (Throwable)e);
            return "error";
        }
    }

    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-list", "*");
        return bundle;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }
}

