/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.struts2.action.AbstractUserCredentialsAction;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesAction
extends AbstractUserCredentialsAction {
    private static final String LIST = "list";
    private List<Role> allRoles;

    public String list() {
        try {
            this.allRoles = this.getFilteredRolesForCurrentUserAccess();
        }
        catch (RbacManagerException e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(e.getMessage());
            this.addActionError(this.getText("cannot.list.all.roles", list));
            this.log.error("System error:", (Throwable)e);
            this.allRoles = Collections.emptyList();
        }
        return LIST;
    }

    public List<Role> getAllRoles() {
        return this.allRoles;
    }

    public void setAllRoles(List<Role> allRoles) {
        this.allRoles = allRoles;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-edit", "*");
        bundle.addRequiredAuthorization("user-management-rbac-admin", "*");
        bundle.addRequiredAuthorization("user-management-role-grant", "*");
        bundle.addRequiredAuthorization("user-management-role-drop", "*");
        bundle.addRequiredAuthorization("user-management-user-role", "*");
        return bundle;
    }
}

