/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.action.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.codehaus.plexus.redback.policy.PasswordEncoder;
import org.codehaus.plexus.redback.policy.PasswordRuleViolationException;
import org.codehaus.plexus.redback.rbac.RBACManager;
import org.codehaus.plexus.redback.rbac.RbacManagerException;
import org.codehaus.plexus.redback.rbac.Role;
import org.codehaus.plexus.redback.struts2.action.AuditEvent;
import org.codehaus.plexus.redback.struts2.action.CancellableAction;
import org.codehaus.plexus.redback.struts2.action.admin.AbstractAdminUserCredentialsAction;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.interceptor.SecureActionBundle;
import org.codehaus.redback.integration.interceptor.SecureActionException;
import org.codehaus.redback.integration.model.AdminEditUserCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserEditAction
extends AbstractAdminUserCredentialsAction
implements CancellableAction {
    private RBACManager rbacManager;
    private List<Role> effectivelyAssignedRoles;
    private AdminEditUserCredentials user;
    private String updateButton;
    private boolean emailValidationRequired;
    private boolean hasHiddenRoles;
    private String oldPassword;
    private String userAdminPassword;
    private boolean self;
    public static String CONFIRM = "confirm";
    public static String CONFIRM_ERROR = "confirmError";

    public String edit() {
        String escapedUsername;
        this.oldPassword = "";
        this.emailValidationRequired = this.securitySystem.getPolicy().getUserValidationSettings().isEmailValidationRequired();
        if (this.getUsername() == null) {
            this.addActionError(this.getText("cannot.edit.user.null.username"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.getUsername())) {
            this.addActionError(this.getText("cannot.edit.user.empty.username"));
            return "error";
        }
        UserManager manager = this.securitySystem.getUserManager();
        if (!manager.userExists((Object)(escapedUsername = StringEscapeUtils.escapeXml((String)this.getUsername())))) {
            this.addActionError(this.getText("user.does.not.exist", Collections.singletonList(escapedUsername)));
            return "error";
        }
        try {
            User u = manager.findUser(escapedUsername);
            if (u == null) {
                this.addActionError(this.getText("cannot.operate.on.null.user"));
                return "error";
            }
            this.user = new AdminEditUserCredentials(u);
            if (this.getUsername().equals(this.getCurrentUser())) {
                this.self = true;
            }
            try {
                String principal = u.getPrincipal().toString();
                List<Role> roles = this.filterAssignableRoles(this.rbacManager.getEffectivelyAssignedRoles(principal));
                this.effectivelyAssignedRoles = this.filterRolesForCurrentUserAccess(roles);
                this.hasHiddenRoles = roles.size() > this.effectivelyAssignedRoles.size();
            }
            catch (RbacManagerException rme) {}
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.get.user", Arrays.asList(this.getUsername(), e.getMessage())));
            return "error";
        }
        return "input";
    }

    private List<Role> filterAssignableRoles(Collection<Role> roles) {
        ArrayList<Role> assignableRoles = new ArrayList<Role>(roles.size());
        for (Role r : roles) {
            if (!r.isAssignable()) continue;
            assignableRoles.add(r);
        }
        return assignableRoles;
    }

    public String submit() {
        if (this.getUsername() == null) {
            this.addActionError(this.getText("cannot.edit.user.null.username"));
            return "error";
        }
        if (StringUtils.isEmpty((String)this.getUsername())) {
            this.addActionError(this.getText("cannot.edit.user.empty.username"));
            return "error";
        }
        if (this.user == null) {
            this.addActionError(this.getText("cannot.edit.user.null.credentials"));
            return "error";
        }
        this.internalUser = this.user;
        this.validateCredentialsLoose();
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        if (!this.getUsername().equals(this.getCurrentUser())) {
            return CONFIRM;
        }
        return this.save(true);
    }

    public String confirmAdminPassword() {
        UserManager manager = this.securitySystem.getUserManager();
        if (StringUtils.isEmpty((String)this.userAdminPassword)) {
            this.addActionError(this.getText("user.admin.password.required"));
            return CONFIRM_ERROR;
        }
        try {
            User currentUser = manager.findUser(this.getCurrentUser());
            PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
            if (!encoder.isPasswordValid(currentUser.getEncodedPassword(), this.userAdminPassword)) {
                this.addActionError(this.getText("user.admin.password.does.not.match.existing"));
                return CONFIRM_ERROR;
            }
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.find.user", Arrays.asList(this.getCurrentUser(), e.getMessage())));
            return CONFIRM_ERROR;
        }
        return this.save(false);
    }

    @Override
    public String cancel() {
        return "cancel";
    }

    private String save(boolean validateOldPassword) {
        UserManager manager = this.securitySystem.getUserManager();
        if (!manager.userExists((Object)this.getUsername())) {
            this.addActionError(this.getText("user.does.not.exist", Collections.singletonList(this.getUsername())));
            return "error";
        }
        try {
            User u = manager.findUser(this.getUsername());
            if (u == null) {
                this.addActionError(this.getText("cannot.operate.on.null.user"));
                return "error";
            }
            if (validateOldPassword) {
                PasswordEncoder encoder = this.securitySystem.getPolicy().getPasswordEncoder();
                if (StringUtils.isEmpty((String)this.oldPassword)) {
                    this.self = true;
                    this.addFieldError("oldPassword", this.getText("old.password.required"));
                    return "error";
                }
                if (!encoder.isPasswordValid(u.getEncodedPassword(), this.oldPassword)) {
                    this.self = true;
                    this.addFieldError("oldPassword", this.getText("password.provided.does.not.match.existing"));
                    return "error";
                }
            }
            u.setFullName(this.user.getFullName());
            u.setEmail(this.user.getEmail());
            u.setPassword(this.user.getPassword());
            u.setLocked(this.user.isLocked());
            u.setPasswordChangeRequired(this.user.isPasswordChangeRequired());
            manager.updateUser(u, this.user.isPasswordChangeRequired());
            if (this.getSecuritySession().getUser().getUsername().equals(u.getUsername())) {
                DefaultSecuritySession securitySession = new DefaultSecuritySession(this.getSecuritySession().getAuthenticationResult(), u);
                this.session.put("securitySession", securitySession);
                this.setSession(this.session);
            }
        }
        catch (UserNotFoundException e) {
            this.addActionError(this.getText("cannot.find.user", Arrays.asList(this.getUsername(), e.getMessage())));
            return "error";
        }
        catch (PasswordRuleViolationException pe) {
            this.processPasswordRuleViolations(pe);
            return "error";
        }
        String currentUser = this.getCurrentUser();
        AuditEvent event = new AuditEvent(this.getText("log.account.edit"));
        event.setAffectedUser(this.getUsername());
        event.setCurrentUser(currentUser);
        event.log();
        return "success";
    }

    public String getUpdateButton() {
        return this.updateButton;
    }

    public void setUpdateButton(String updateButton) {
        this.updateButton = updateButton;
    }

    public AdminEditUserCredentials getUser() {
        return this.user;
    }

    public void setUser(AdminEditUserCredentials user) {
        this.user = user;
    }

    @Override
    public SecureActionBundle initSecureActionBundle() throws SecureActionException {
        SecureActionBundle bundle = new SecureActionBundle();
        bundle.setRequiresAuthentication(true);
        bundle.addRequiredAuthorization("user-management-user-edit", "*");
        bundle.addRequiredAuthorization("user-management-user-edit", this.getUsername());
        bundle.addRequiredAuthorization("user-management-user-role", "*");
        return bundle;
    }

    public List<Role> getEffectivelyAssignedRoles() {
        return this.effectivelyAssignedRoles;
    }

    public boolean isEmailValidationRequired() {
        return this.emailValidationRequired;
    }

    public boolean isHasHiddenRoles() {
        return this.hasHiddenRoles;
    }

    public void setHasHiddenRoles(boolean hasHiddenRoles) {
        this.hasHiddenRoles = hasHiddenRoles;
    }

    public void setOldPassword(String oldPassword) {
        this.oldPassword = oldPassword;
    }

    public void setUserAdminPassword(String userAdminPassword) {
        this.userAdminPassword = userAdminPassword;
    }

    public boolean isSelf() {
        return this.self;
    }
}

