/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.checks;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.redback.integration.checks.xwork.XworkActionConfig;
import org.codehaus.redback.integration.checks.xwork.XworkPackageConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractXworkConfigurationCheck {
    protected void checkAction(List<String> violations, XworkPackageConfig expectedPackage, XworkActionConfig expectedAction, Map<?, ?> xwActionMap) {
        ActionConfig xwActionConfig = (ActionConfig)xwActionMap.get(expectedAction.name);
        if (xwActionConfig != null) {
            if (StringUtils.isNotEmpty((String)expectedAction.clazz) && !StringUtils.equals((String)expectedAction.clazz, (String)xwActionConfig.getClassName())) {
                violations.add("xwork.xml - Expected class attribute value of " + this.quote(expectedAction.clazz) + " but got " + this.quote(xwActionConfig.getClassName()) + " instead, on action " + this.quote(expectedAction.name) + " in package " + this.quote(expectedPackage.name) + ".");
            }
            if (StringUtils.isNotEmpty((String)expectedAction.method) && !StringUtils.equals((String)expectedAction.method, (String)xwActionConfig.getMethodName())) {
                violations.add("xwork.xml - Expected method attribute value of " + this.quote(expectedAction.method) + " but got " + this.quote(xwActionConfig.getMethodName()) + " instead, on action " + this.quote(expectedAction.name) + " in package " + this.quote(expectedPackage.name) + ".");
            }
            Map xwResultMap = xwActionConfig.getResults();
            if (expectedAction.results.isEmpty()) {
                if (xwResultMap.size() < 1) {
                    violations.add("xwork.xml - Missing default result on action name " + this.quote(expectedAction.name) + " in package " + this.quote(expectedPackage.name) + ".");
                }
            } else {
                for (String resultName : expectedAction.results) {
                    if (xwResultMap.get(resultName) != null) continue;
                    violations.add("xwork.xml - Missing named result " + this.quote(resultName) + " in action " + this.quote(expectedAction.name) + " in package " + this.quote(expectedPackage.name) + ".");
                }
            }
        } else {
            violations.add("xwork.xml - Missing action named " + this.quote(expectedAction.name) + " in package " + this.quote(expectedPackage.name) + ".");
        }
    }

    protected void checkPackage(List<String> violations, XworkPackageConfig expectedPackage, Configuration xwConfig) {
        PackageConfig xwPackageConfig = this.findPackageNamespace(xwConfig, expectedPackage.name);
        if (xwPackageConfig != null) {
            Map xwActionMap = xwPackageConfig.getActionConfigs();
            for (XworkActionConfig expectedAction : expectedPackage.actions) {
                this.checkAction(violations, expectedPackage, expectedAction, xwActionMap);
            }
        } else {
            violations.add("Missing " + this.quote(expectedPackage.name) + " package namespace in xwork.xml");
        }
    }

    protected PackageConfig findPackageNamespace(Configuration xwConfig, String name) {
        Map xwPackageConfigMap = xwConfig.getPackageConfigs();
        for (PackageConfig xwPackageConfig : xwPackageConfigMap.values()) {
            if (!StringUtils.equals((String)name, (String)xwPackageConfig.getNamespace())) continue;
            return xwPackageConfig;
        }
        return null;
    }

    protected String quote(Object o) {
        if (o == null) {
            return "<null>";
        }
        return "\"" + o.toString() + "\"";
    }
}

