/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authentication.TokenBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.keys.AuthenticationKey;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.redback.integration.util.AutoLoginCookies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoLoginInterceptor
implements Interceptor {
    private Logger log = LoggerFactory.getLogger(AutoLoginInterceptor.class);
    static final String PASSWORD_CHANGE = "security-must-change-password";
    static final String ACCOUNT_LOCKED = "security-login-locked";
    private SecuritySystem securitySystem;
    private AutoLoginCookies autologinCookies;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        SecuritySession securitySession = this.getSecuritySession();
        if (securitySession != null && securitySession.isAuthenticated()) {
            this.log.debug("User already authenticated.");
            if (!this.checkCookieConsistency(securitySession)) {
                this.autologinCookies.setSignonCookie(securitySession.getUser().getUsername(), ServletActionContext.getResponse(), ServletActionContext.getRequest());
            }
        } else {
            AuthenticationKey authkey = this.autologinCookies.getSignonKey(ServletActionContext.getResponse(), ServletActionContext.getRequest());
            if (authkey != null) {
                try {
                    securitySession = this.checkAuthentication(authkey, invocation.getInvocationContext().getName().equals(PASSWORD_CHANGE));
                    if (securitySession != null && securitySession.isAuthenticated()) {
                        this.checkCookieConsistency(securitySession);
                    }
                    this.autologinCookies.removeSignonCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                    this.autologinCookies.removeRememberMeCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                }
                catch (AccountLockedException e) {
                    this.log.info("Account Locked : Username [" + e.getUser().getUsername() + "]", (Throwable)e);
                    this.autologinCookies.removeSignonCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                    this.autologinCookies.removeRememberMeCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                    return ACCOUNT_LOCKED;
                }
                catch (MustChangePasswordException e) {
                    return PASSWORD_CHANGE;
                }
            } else if (this.autologinCookies.isRememberMeEnabled() && (authkey = this.autologinCookies.getRememberMeKey(ServletActionContext.getResponse(), ServletActionContext.getRequest())) != null) {
                try {
                    securitySession = this.checkAuthentication(authkey, false);
                    if (securitySession == null || !securitySession.isAuthenticated()) {
                        this.autologinCookies.removeRememberMeCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                    }
                }
                catch (AccountLockedException e) {
                    this.log.info("Account Locked : Username [" + e.getUser().getUsername() + "]", (Throwable)e);
                    this.autologinCookies.removeRememberMeCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
                    return ACCOUNT_LOCKED;
                }
                catch (MustChangePasswordException e) {
                    return PASSWORD_CHANGE;
                }
            }
        }
        return invocation.invoke();
    }

    private boolean checkCookieConsistency(SecuritySession securitySession) {
        String username = securitySession.getUser().getUsername();
        boolean failed = false;
        AuthenticationKey key = this.autologinCookies.getRememberMeKey(ServletActionContext.getResponse(), ServletActionContext.getRequest());
        if (key != null && !key.getForPrincipal().equals(username)) {
            this.log.debug("Login invalidated: remember me cookie was for " + key.getForPrincipal() + "; but session was for " + username);
            failed = true;
        }
        if (!failed) {
            key = this.autologinCookies.getSignonKey(ServletActionContext.getResponse(), ServletActionContext.getRequest());
            if (key != null) {
                if (!key.getForPrincipal().equals(username)) {
                    this.log.debug("Login invalidated: signon cookie was for " + key.getForPrincipal() + "; but session was for " + username);
                    failed = true;
                }
            } else {
                this.log.debug("Login invalidated: signon cookie was removed");
                failed = true;
            }
        }
        if (failed) {
            this.removeCookiesAndSession();
        }
        return failed;
    }

    private SecuritySession checkAuthentication(AuthenticationKey authkey, boolean enforcePasswordChange) throws AccountLockedException, MustChangePasswordException {
        SecuritySession securitySession = null;
        this.log.debug("Logging in with an authentication key: " + authkey.getForPrincipal());
        TokenBasedAuthenticationDataSource authsource = new TokenBasedAuthenticationDataSource();
        authsource.setPrincipal(authkey.getForPrincipal());
        authsource.setToken(authkey.getKey());
        authsource.setEnforcePasswordChange(enforcePasswordChange);
        try {
            securitySession = this.securitySystem.authenticate((AuthenticationDataSource)authsource);
            if (securitySession.isAuthenticated()) {
                this.log.debug("Login success.");
                HttpSession session = ServletActionContext.getRequest().getSession(true);
                session.setAttribute("securitySession", (Object)securitySession);
                this.log.debug("Setting session:securitySession to " + securitySession);
                this.autologinCookies.setSignonCookie(authkey.getForPrincipal(), ServletActionContext.getResponse(), ServletActionContext.getRequest());
            } else {
                AuthenticationResult result = securitySession.getAuthenticationResult();
                this.log.info("Login interceptor failed against principal : " + result.getPrincipal(), (Throwable)result.getException());
            }
        }
        catch (AuthenticationException e) {
            this.log.info("Authentication Exception.", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            this.log.info("User Not Found: " + authkey.getForPrincipal(), (Throwable)e);
        }
        return securitySession;
    }

    private void removeCookiesAndSession() {
        this.autologinCookies.removeRememberMeCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
        this.autologinCookies.removeSignonCookie(ServletActionContext.getResponse(), ServletActionContext.getRequest());
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session != null) {
            session.removeAttribute("securitySession");
        }
    }

    private SecuritySession getSecuritySession() {
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session == null) {
            this.log.debug("No HTTP Session exists.");
            return null;
        }
        SecuritySession secSession = (SecuritySession)session.getAttribute("securitySession");
        this.log.debug("Returning Security Session: " + secSession);
        return secSession;
    }
}

