/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.struts2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import org.codehaus.plexus.redback.configuration.UserConfiguration;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceAdminUserInterceptor
implements Interceptor {
    private Logger log = LoggerFactory.getLogger(ForceAdminUserInterceptor.class);
    private static final String SECURITY_ADMIN_USER_NEEDED = "security-admin-user-needed";
    private static boolean checked = false;
    private UserManager userManager;
    private RoleManager roleManager;
    private UserConfiguration config;

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (checked) {
            return invocation.invoke();
        }
        try {
            User user = this.userManager.findUser(this.config.getString("redback.default.admin"));
            if (user == null) {
                this.log.info("No admin user configured - forwarding to admin user creation page.");
                return SECURITY_ADMIN_USER_NEEDED;
            }
            this.roleManager.assignRole("system-administrator", user.getPrincipal().toString());
            checked = true;
            this.log.info("Admin user found. No need to configure admin user.");
        }
        catch (UserNotFoundException e) {
            this.log.info("No admin user found - forwarding to admin user creation page.");
            return SECURITY_ADMIN_USER_NEEDED;
        }
        return invocation.invoke();
    }
}

