/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.system;

import javax.annotation.Resource;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.AuthenticationManager;
import org.codehaus.plexus.redback.authentication.AuthenticationResult;
import org.codehaus.plexus.redback.authorization.AuthorizationDataSource;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.authorization.AuthorizationResult;
import org.codehaus.plexus.redback.authorization.Authorizer;
import org.codehaus.plexus.redback.keys.KeyManager;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.policy.MustChangePasswordException;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="securitySystem")
public class DefaultSecuritySystem
implements SecuritySystem {
    private Logger log = LoggerFactory.getLogger(DefaultSecuritySystem.class);
    @Resource
    private AuthenticationManager authnManager;
    @Resource(name="authorizer#rbac")
    private Authorizer authorizer;
    @Resource(name="userManager#configurable")
    private UserManager userManager;
    @Resource(name="keyManager#cached")
    private KeyManager keyManager;
    @Resource
    private UserSecurityPolicy policy;

    public SecuritySession authenticate(AuthenticationDataSource source) throws AuthenticationException, UserNotFoundException, AccountLockedException, MustChangePasswordException {
        AuthenticationResult result = this.authnManager.authenticate(source);
        this.log.debug("authnManager.authenticate() result: " + result);
        if (result.isAuthenticated()) {
            this.log.debug("User '" + result.getPrincipal() + "' authenticated.");
            if (this.userManager.userExists(result.getPrincipal())) {
                this.log.debug("User '" + result.getPrincipal() + "' exists.");
                User user = this.userManager.findUser(result.getPrincipal());
                this.log.debug("User: " + user);
                return new DefaultSecuritySession(result, user);
            }
            this.log.debug("User '" + result.getPrincipal() + "' DOES NOT exist.");
            return new DefaultSecuritySession(result);
        }
        this.log.debug("User '" + result.getPrincipal() + "' IS NOT authenticated.");
        return new DefaultSecuritySession(result);
    }

    public boolean isAuthenticated(AuthenticationDataSource source) throws AuthenticationException, UserNotFoundException, AccountLockedException, MustChangePasswordException {
        return this.authenticate(source).getAuthenticationResult().isAuthenticated();
    }

    public String getAuthenticatorId() {
        if (this.authnManager == null) {
            return "<null>";
        }
        return this.authnManager.getId();
    }

    public AuthorizationResult authorize(SecuritySession session, Object permission) throws AuthorizationException {
        return this.authorize(session, permission, null);
    }

    public AuthorizationResult authorize(SecuritySession session, Object permission, Object resource) throws AuthorizationException {
        User user;
        AuthorizationDataSource source = null;
        if (session != null && (user = session.getUser()) != null) {
            source = new AuthorizationDataSource(user.getPrincipal(), user, permission, resource);
        }
        if (source == null) {
            source = new AuthorizationDataSource(null, null, permission, resource);
        }
        return this.authorizer.isAuthorized(source);
    }

    public boolean isAuthorized(SecuritySession session, Object permission) throws AuthorizationException {
        return this.isAuthorized(session, permission, null);
    }

    public boolean isAuthorized(SecuritySession session, Object permission, Object resource) throws AuthorizationException {
        return this.authorize(session, permission, resource).isAuthorized();
    }

    public String getAuthorizerId() {
        if (this.authorizer == null) {
            return "<null>";
        }
        return this.authorizer.getId();
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public String getUserManagementId() {
        if (this.userManager == null) {
            return "<null>";
        }
        return this.userManager.getId();
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public String getKeyManagementId() {
        if (this.keyManager == null) {
            return "<null>";
        }
        return this.keyManager.getId();
    }

    public UserSecurityPolicy getPolicy() {
        return this.policy;
    }

    public String getPolicyId() {
        if (this.policy == null) {
            return "<null>";
        }
        return this.policy.getId();
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authnManager;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }
}

