/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.jdo;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.jdo.Extent;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.jdo.PlexusObjectNotFoundException;
import org.codehaus.plexus.jdo.PlexusStoreException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.users.AbstractUserManager;
import org.codehaus.plexus.redback.users.PermanentUserException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManagerException;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.redback.users.UserQuery;
import org.codehaus.plexus.redback.users.jdo.JdoUser;
import org.codehaus.plexus.redback.users.jdo.JdoUserQuery;
import org.codehaus.plexus.redback.users.jdo.Messages;
import org.codehaus.plexus.redback.users.jdo.UsersManagementModelloMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="userManager#jdo")
public class JdoUserManager
extends AbstractUserManager
implements Initializable {
    @Resource(name="jdoFactory#users")
    private JdoFactory jdoFactory;
    @Resource
    private UserSecurityPolicy userSecurityPolicy;
    private PersistenceManagerFactory pmf;
    private boolean hasTriggeredInit = false;

    public String getId() {
        return "JDO UserManager - " + ((Object)((Object)this)).getClass().getName();
    }

    public boolean isReadOnly() {
        return false;
    }

    public UserQuery createUserQuery() {
        return new JdoUserQuery();
    }

    public User createUser(String username, String fullname, String email) {
        JdoUser user = new JdoUser();
        user.setUsername(username);
        user.setFullName(fullname);
        user.setEmail(email);
        user.setAccountCreationDate(new Date());
        return user;
    }

    public List<User> getUsers() {
        return this.getAllObjectsDetached(null);
    }

    public List<User> getUsers(boolean orderAscending) {
        String ordering = orderAscending ? "username ascending" : "username descending";
        return this.getAllObjectsDetached(ordering);
    }

    private List<User> getAllObjectsDetached(String ordering) {
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(), JdoUser.class, (String)ordering, (String)null);
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) {
        return this.findUsers("username", usernameKey, orderAscending);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) {
        return this.findUsers("fullName", fullNameKey, orderAscending);
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) {
        return this.findUsers("email", emailKey, orderAscending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findUsersByQuery(UserQuery userQuery) {
        JdoUserQuery uq = (JdoUserQuery)userQuery;
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(JdoUser.class, true);
            Query query = pm.newQuery(extent);
            String ordering = uq.getOrdering();
            query.setOrdering(ordering);
            query.declareImports("import java.lang.String");
            query.declareParameters(uq.getParameters());
            query.setFilter(uq.getFilter());
            query.setRange(uq.getFirstResult(), uq.getMaxResults() < 0L ? Long.MAX_VALUE : uq.getFirstResult() + uq.getMaxResults());
            List result = (List)query.executeWithArray((Object[])uq.getSearchKeys());
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<User> findUsers(String searchField, String searchKey, boolean ascendingUsername) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(JdoUser.class, true);
            Query query = pm.newQuery(extent);
            String ordering = ascendingUsername ? "username ascending" : "username descending";
            query.setOrdering(ordering);
            query.declareImports("import java.lang.String");
            query.declareParameters("String searchKey");
            query.setFilter("this." + searchField + ".toLowerCase().indexOf(searchKey.toLowerCase()) > -1");
            List result = (List)query.execute((Object)searchKey);
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public User addUser(User user) {
        if (!(user instanceof JdoUser)) {
            throw new UserManagerException("Unable to Add User. User object " + user.getClass().getName() + " is not an instance of " + JdoUser.class.getName());
        }
        if (StringUtils.isEmpty((String)user.getUsername())) {
            throw new IllegalStateException(Messages.getString("user.manager.cannot.add.user.without.username"));
        }
        this.userSecurityPolicy.extensionChangePassword(user);
        this.fireUserManagerUserAdded(user);
        if ("admin".equals(user.getUsername())) {
            user.setPasswordChangeRequired(false);
        } else {
            user.setPasswordChangeRequired(true);
        }
        return (User)this.addObject(user);
    }

    public void deleteUser(Object principal) {
        try {
            User user = this.findUser(principal);
            if (user.isPermanent()) {
                throw new PermanentUserException("Cannot delete permanent user [" + user.getUsername() + "].");
            }
            this.fireUserManagerUserRemoved(user);
            this.removeObject(user);
        }
        catch (UserNotFoundException e) {
            this.log.warn("Unable to delete user " + principal + ", user not found.", (Throwable)e);
        }
    }

    public void deleteUser(String username) {
        try {
            User user = this.findUser(username);
            if (user.isPermanent()) {
                throw new PermanentUserException("Cannot delete permanent user [" + user.getUsername() + "].");
            }
            this.fireUserManagerUserRemoved(user);
            PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)user);
        }
        catch (UserNotFoundException e) {
            this.log.warn("Unable to delete user " + username + ", user not found.", (Throwable)e);
        }
    }

    public void addUserUnchecked(User user) {
        if (!(user instanceof JdoUser)) {
            throw new UserManagerException("Unable to Add User. User object " + user.getClass().getName() + " is not an instance of " + JdoUser.class.getName());
        }
        if (StringUtils.isEmpty((String)user.getUsername())) {
            throw new IllegalStateException(Messages.getString("user.manager.cannot.add.user.without.username"));
        }
        this.addObject(user);
    }

    public void eraseDatabase() {
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), JdoUser.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), UsersManagementModelloMetadata.class);
    }

    public User findUser(Object principal) throws UserNotFoundException {
        if (principal == null) {
            throw new UserNotFoundException("Unable to find user based on null principal.");
        }
        try {
            return (User)PlexusJdoUtils.getObjectById((PersistenceManager)this.getPersistenceManager(), JdoUser.class, (String)principal.toString(), null);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new UserNotFoundException("Unable to find user: " + e.getMessage(), (Throwable)e);
        }
        catch (PlexusStoreException e) {
            throw new UserNotFoundException("Unable to find user: " + e.getMessage(), (Throwable)e);
        }
    }

    public User findUser(String username) throws UserNotFoundException {
        if (StringUtils.isEmpty((String)username)) {
            throw new UserNotFoundException("User with empty username not found.");
        }
        return (User)this.getObjectById(username, null);
    }

    public boolean userExists(Object principal) {
        try {
            this.findUser(principal);
            return true;
        }
        catch (UserNotFoundException ne) {
            return false;
        }
    }

    public User updateUser(User user) throws UserNotFoundException {
        return this.updateUser(user, false);
    }

    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException {
        if (!(user instanceof JdoUser)) {
            throw new UserManagerException("Unable to Update User. User object " + user.getClass().getName() + " is not an instance of " + JdoUser.class.getName());
        }
        if (StringUtils.isNotEmpty((String)user.getPassword())) {
            this.userSecurityPolicy.extensionChangePassword(user, passwordChangeRequired);
        }
        this.updateObject(user);
        this.fireUserManagerUserUpdated(user);
        return user;
    }

    public void initialize() throws InitializationException {
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
    }

    public PersistenceManager getPersistenceManager() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        this.triggerInit();
        return pm;
    }

    private Object addObject(Object object) {
        return PlexusJdoUtils.addObject((PersistenceManager)this.getPersistenceManager(), (Object)object);
    }

    private Object getObjectById(String id, String fetchGroup) throws UserNotFoundException, UserManagerException {
        try {
            return PlexusJdoUtils.getObjectById((PersistenceManager)this.getPersistenceManager(), JdoUser.class, (String)id, (String)fetchGroup);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new UserNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new UserManagerException("Unable to get object '" + JdoUser.class.getName() + "', id '" + id + "', fetch-group '" + fetchGroup + "' from jdo store.");
        }
    }

    private Object removeObject(Object o) {
        if (o == null) {
            throw new UserManagerException("Unable to remove null object");
        }
        PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)o);
        return o;
    }

    private Object updateObject(Object object) throws UserNotFoundException, UserManagerException {
        try {
            return PlexusJdoUtils.updateObject((PersistenceManager)this.getPersistenceManager(), (Object)object);
        }
        catch (PlexusStoreException e) {
            throw new UserManagerException("Unable to update the '" + object.getClass().getName() + "' object in the jdo database.", (Throwable)e);
        }
    }

    private void rollback(Transaction tx) {
        PlexusJdoUtils.rollbackIfActive((Transaction)tx);
    }

    public void triggerInit() {
        if (!this.hasTriggeredInit) {
            this.hasTriggeredInit = true;
            List<User> users = this.getAllObjectsDetached(null);
            this.fireUserManagerInit(users.isEmpty());
        }
    }

    public JdoFactory getJdoFactory() {
        return this.jdoFactory;
    }

    public void setJdoFactory(JdoFactory jdoFactory) {
        this.jdoFactory = jdoFactory;
    }

    public UserSecurityPolicy getUserSecurityPolicy() {
        return this.userSecurityPolicy;
    }
}

