/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.naming.directory.DirContext;
import org.codehaus.plexus.redback.common.ldap.LdapUser;
import org.codehaus.plexus.redback.common.ldap.MappingException;
import org.codehaus.plexus.redback.common.ldap.UserMapper;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnection;
import org.codehaus.plexus.redback.common.ldap.connection.LdapConnectionFactory;
import org.codehaus.plexus.redback.common.ldap.connection.LdapException;
import org.codehaus.plexus.redback.users.AbstractUserManager;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.redback.users.UserQuery;
import org.codehaus.plexus.redback.users.ldap.LdapUserQuery;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapController;
import org.codehaus.plexus.redback.users.ldap.ctl.LdapControllerException;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="userManager#ldap")
public class LdapUserManager
extends AbstractUserManager {
    @Resource(name="ldapConnectionFactory#configurable")
    private LdapConnectionFactory connectionFactory;
    @Resource
    private LdapController controller;
    @Resource(name="userMapper#ldap")
    private UserMapper mapper;
    private User guestUser;

    public boolean isReadOnly() {
        return true;
    }

    public User addUser(User user) {
        return this.addUser(user, true);
    }

    public void addUserUnchecked(User user) {
        this.addUser(user, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User addUser(User user, boolean checked) {
        if (user == null) {
            return null;
        }
        if ("guest".equals(user.getUsername())) {
            this.guestUser = user;
            return this.guestUser;
        }
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            this.controller.createUser(user, context, checked);
        }
        catch (LdapControllerException e) {
            this.log.error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
        catch (MappingException e) {
            this.log.error("Error mapping user: " + user.getPrincipal() + " to LDAP attributes.", (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return user;
    }

    public User createUser(String username, String fullName, String emailAddress) {
        return this.mapper.newUserInstance(username, fullName, emailAddress);
    }

    public UserQuery createUserQuery() {
        return new LdapUserQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(Object principal) throws UserNotFoundException {
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            this.controller.removeUser(principal, context);
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to delete user: " + principal, (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String username) throws UserNotFoundException {
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            this.controller.removeUser(username, context);
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to delete user: " + username, (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public void eraseDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(String username) throws UserNotFoundException {
        if (username == null) {
            throw new UserNotFoundException("Unable to find user based on null username.");
        }
        if ("guest".equals(username)) {
            return this.getGuestUser();
        }
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            LdapUser user = this.controller.getUser(username, context);
            if (user == null) {
                throw new UserNotFoundException("user with name " + username + " not found ");
            }
            LdapUser ldapUser = user;
            return ldapUser;
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to find user: " + username, (Throwable)e);
            User user = null;
            return user;
        }
        catch (MappingException e) {
            this.log.error("Failed to map user: " + username, (Throwable)e);
            User user = null;
            return user;
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public User getGuestUser() throws UserNotFoundException {
        if (this.guestUser == null) {
            throw new UserNotFoundException("Guest user doesn't exist.");
        }
        return this.guestUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findUser(Object principal) throws UserNotFoundException {
        if (principal == null) {
            throw new UserNotFoundException("Unable to find user based on null principal.");
        }
        if ("guest".equals(principal.toString())) {
            return this.getGuestUser();
        }
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            LdapUser ldapUser = this.controller.getUser(principal, context);
            return ldapUser;
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to find user: " + principal, (Throwable)e);
            User user = null;
            return user;
        }
        catch (MappingException e) {
            this.log.error("Failed to map user: " + principal, (Throwable)e);
            User user = null;
            return user;
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) {
        LdapUserQuery query = new LdapUserQuery();
        query.setEmail(emailKey);
        query.setOrderBy("email");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) {
        LdapUserQuery query = new LdapUserQuery();
        query.setFullName(fullNameKey);
        query.setOrderBy("fullname");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findUsersByQuery(UserQuery query) {
        if (query == null) {
            return Collections.emptyList();
        }
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            List<User> list = this.controller.getUsersByQuery((LdapUserQuery)query, context);
            return list;
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to find user", (Throwable)e);
            List<User> list = null;
            return list;
        }
        catch (MappingException e) {
            this.log.error("Failed to map user", (Throwable)e);
            List<User> list = null;
            return list;
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) {
        LdapUserQuery query = new LdapUserQuery();
        query.setUsername(usernameKey);
        query.setOrderBy("username");
        query.setAscending(orderAscending);
        return this.findUsersByQuery((UserQuery)query);
    }

    public String getId() {
        return "LDAP User-Manager: " + ((Object)((Object)this)).getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getUsers() {
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            ArrayList<User> users = new ArrayList<User>();
            users.addAll(this.controller.getUsers(context));
            try {
                User u = this.getGuestUser();
                if (u != null) {
                    users.add(u);
                }
            }
            catch (UserNotFoundException e) {
                // empty catch block
            }
            ArrayList<User> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return Collections.emptyList();
    }

    public List<User> getUsers(boolean orderAscending) {
        return this.getUsers();
    }

    public User updateUser(User user) throws UserNotFoundException {
        return this.updateUser(user, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User updateUser(User user, boolean passwordChangeRequired) throws UserNotFoundException {
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            this.controller.updateUser(user, context);
        }
        catch (LdapControllerException e) {
            this.log.error("Failed to update user: " + user.getPrincipal(), (Throwable)e);
        }
        catch (MappingException e) {
            this.log.error("Failed to update user: " + user.getPrincipal(), (Throwable)e);
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userExists(Object principal) {
        LdapConnection ldapConnection = this.getLdapConnection();
        try {
            DirContext context = ldapConnection.getDirContext();
            boolean bl = this.controller.userExists(principal, context);
            return bl;
        }
        catch (LdapControllerException e) {
            this.log.warn("Failed to search for user: " + principal, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeLdapConnection(ldapConnection);
        }
    }

    private LdapConnection getLdapConnection() {
        try {
            return this.connectionFactory.getConnection();
        }
        catch (LdapException e) {
            this.log.warn("failed to get a ldap connection " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("failed to get a ldap connection " + e.getMessage(), e);
        }
    }

    private void closeLdapConnection(LdapConnection ldapConnection) {
        if (ldapConnection != null) {
            ldapConnection.close();
        }
    }
}

