/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.redback.users.memory;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.codehaus.plexus.redback.policy.UserSecurityPolicy;
import org.codehaus.plexus.redback.users.AbstractUserManager;
import org.codehaus.plexus.redback.users.PermanentUserException;
import org.codehaus.plexus.redback.users.User;
import org.codehaus.plexus.redback.users.UserManager;
import org.codehaus.plexus.redback.users.UserNotFoundException;
import org.codehaus.plexus.redback.users.UserQuery;
import org.codehaus.plexus.redback.users.memory.SimpleUser;
import org.codehaus.plexus.redback.users.memory.SimpleUserQuery;
import org.codehaus.plexus.redback.users.memory.util.UserSorter;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="userManager#memory")
public class MemoryUserManager
extends AbstractUserManager
implements UserManager {
    @Resource
    private UserSecurityPolicy userSecurityPolicy;
    private Map<Object, User> users = new HashMap<Object, User>();
    private boolean hasTriggeredInit = false;

    public String getId() {
        Properties props = new Properties();
        URL url = ((Object)((Object)this)).getClass().getResource("META-INF/maven/org/codehaus/plexus/redback/redback-users-memory/pom.properties");
        if (url != null) {
            try {
                props.load(url.openStream());
                return "MemoryUserManager - " + props.getProperty("version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "MemoryUserManager - (unknown version)";
    }

    public boolean isReadOnly() {
        return false;
    }

    public UserQuery createUserQuery() {
        return new SimpleUserQuery();
    }

    public List<User> findUsersByQuery(UserQuery query) {
        SimpleUserQuery uq = (SimpleUserQuery)query;
        ArrayList<SimpleUser> list = new ArrayList<SimpleUser>();
        for (SimpleUser simpleUser : this.users.values()) {
            boolean matches = uq.matches(simpleUser);
            if (!matches) continue;
            list.add(simpleUser);
        }
        Collections.sort(list, uq.getComparator());
        ArrayList<User> cutList = new ArrayList<User>();
        for (long i = query.getFirstResult(); i < (long)list.size() && (query.getMaxResults() == -1L || i < query.getFirstResult() + uq.getMaxResults()); ++i) {
            cutList.add((User)list.get((int)i));
        }
        return cutList;
    }

    public User addUser(User user) {
        this.saveUser(user);
        this.fireUserManagerUserAdded(user);
        if (StringUtils.isEmpty((String)user.getEncodedPassword())) {
            this.userSecurityPolicy.extensionChangePassword(user);
        }
        return user;
    }

    private void saveUser(User user) {
        this.triggerInit();
        this.users.put(user.getPrincipal(), user);
    }

    public User updateUser(User user) {
        return this.updateUser(user, false);
    }

    public User updateUser(User user, boolean passwordChangeRequired) {
        if (StringUtils.isNotEmpty((String)user.getPassword())) {
            this.userSecurityPolicy.extensionChangePassword(user, passwordChangeRequired);
        }
        this.saveUser(user);
        this.fireUserManagerUserUpdated(user);
        return user;
    }

    public User findUser(Object principal) throws UserNotFoundException {
        this.triggerInit();
        User user = this.users.get(principal);
        if (user == null) {
            throw new UserNotFoundException("Cannot find the user with the principal '" + principal + "'.");
        }
        return user;
    }

    public boolean userExists(Object principal) {
        try {
            this.findUser(principal);
            return true;
        }
        catch (UserNotFoundException ne) {
            return false;
        }
    }

    public void deleteUser(Object principal) throws UserNotFoundException {
        this.deleteUser(principal.toString());
    }

    public User createUser(String username, String fullName, String emailAddress) {
        SimpleUser user = new SimpleUser();
        user.setUsername(username);
        user.setFullName(fullName);
        user.setEmail(emailAddress);
        return user;
    }

    public void deleteUser(String username) throws UserNotFoundException {
        User user = this.findUser(username);
        if (user.isPermanent()) {
            throw new PermanentUserException("Cannot delete permanent user.");
        }
        this.users.remove(user.getPrincipal());
        this.fireUserManagerUserRemoved(user);
    }

    public void addUserUnchecked(User user) {
        this.addUser(user);
    }

    public void eraseDatabase() {
        this.users.clear();
    }

    public User findUser(String username) throws UserNotFoundException {
        this.triggerInit();
        User user = null;
        for (User u : this.users.values()) {
            if (!u.getUsername().equals(username)) continue;
            user = u;
        }
        if (user == null) {
            throw new UserNotFoundException("Unable to find user '" + username + "'");
        }
        return user;
    }

    public List<User> findUsersByUsernameKey(String usernameKey, boolean orderAscending) {
        this.triggerInit();
        ArrayList<User> userList = new ArrayList<User>();
        for (User u : this.users.values()) {
            if (u.getUsername().indexOf(usernameKey) <= -1) continue;
            userList.add(u);
        }
        Collections.sort(userList, new UserSorter(orderAscending));
        return userList;
    }

    public List<User> findUsersByFullNameKey(String fullNameKey, boolean orderAscending) {
        this.triggerInit();
        ArrayList<User> userList = new ArrayList<User>();
        for (User u : this.users.values()) {
            if (u.getFullName().indexOf(fullNameKey) <= -1) continue;
            userList.add(u);
        }
        Collections.sort(userList, new UserSorter(orderAscending));
        return userList;
    }

    public List<User> findUsersByEmailKey(String emailKey, boolean orderAscending) {
        this.triggerInit();
        ArrayList<User> userList = new ArrayList<User>();
        for (User u : this.users.values()) {
            if (u.getEmail().indexOf(emailKey) <= -1) continue;
            userList.add(u);
        }
        Collections.sort(userList, new UserSorter(orderAscending));
        return userList;
    }

    public List<User> getUsers() {
        this.triggerInit();
        return new ArrayList<User>(this.users.values());
    }

    public List<User> getUsers(boolean ascendingUsername) {
        return this.getUsers();
    }

    public void triggerInit() {
        if (!this.hasTriggeredInit) {
            this.fireUserManagerInit(this.users.isEmpty());
            this.hasTriggeredInit = true;
        }
    }
}

