/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.java.JavaSquid;
import org.sonar.java.api.JavaClass;
import org.sonar.java.api.JavaMethod;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.plugins.java.bridges.BridgeFactory;
import org.sonar.plugins.java.bridges.ResourceIndex;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridges {
    private final JavaSquid squid;

    public Bridges(JavaSquid squid) {
        this.squid = squid;
    }

    public void save(SensorContext context, Project project, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        boolean skipPackageDesignAnalysis = project.getConfiguration().getBoolean("sonar.skipPackageDesign", false);
        ResourceIndex resourceIndex = new ResourceIndex().loadSquidResources(this.squid, context, project);
        List<Bridge> bridges = BridgeFactory.create(this.squid.isBytecodeScanned(), skipPackageDesignAnalysis, context, checkFactory, resourceIndex, this.squid, noSonarFilter);
        this.saveProject(resourceIndex, bridges);
        this.savePackages(resourceIndex, bridges);
        this.saveFiles(resourceIndex, bridges);
        this.saveClasses(resourceIndex, bridges);
        this.saveMethods(resourceIndex, bridges);
    }

    private void saveProject(ResourceIndex resourceIndex, List<Bridge> bridges) {
        SourceProject squidProject = (SourceProject)this.squid.search(new QueryByType(SourceProject.class)).iterator().next();
        Resource sonarResource = (Resource)resourceIndex.get(squidProject);
        for (Bridge bridge : bridges) {
            bridge.onProject(squidProject, (Project)sonarResource);
        }
    }

    private void savePackages(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection packages = this.squid.search(new QueryByType(SourcePackage.class));
        for (SourceCode squidPackage : packages) {
            Resource sonarPackage = (Resource)resourceIndex.get(squidPackage);
            for (Bridge bridge : bridges) {
                bridge.onPackage((SourcePackage)squidPackage, sonarPackage);
            }
        }
    }

    private void saveFiles(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidFiles = this.squid.search(new QueryByType(SourceFile.class));
        for (SourceCode squidFile : squidFiles) {
            Resource sonarFile = (Resource)resourceIndex.get(squidFile);
            for (Bridge bridge : bridges) {
                bridge.onFile((SourceFile)squidFile, sonarFile);
            }
        }
    }

    private void saveClasses(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidClasses = this.squid.search(new QueryByType(SourceClass.class));
        for (SourceCode squidClass : squidClasses) {
            Resource sonarClass = (Resource)resourceIndex.get(squidClass);
            if (sonarClass == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onClass((SourceClass)squidClass, (JavaClass)sonarClass);
            }
        }
    }

    private void saveMethods(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidMethods = this.squid.search(new QueryByType(SourceMethod.class));
        for (SourceCode squidMethod : squidMethods) {
            JavaMethod sonarMethod = (JavaMethod)resourceIndex.get(squidMethod);
            if (sonarMethod == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onMethod((SourceMethod)squidMethod, sonarMethod);
            }
        }
    }
}

