/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.java.JavaConfiguration;
import org.sonar.java.JavaSquid;
import org.sonar.java.checks.CheckList;
import org.sonar.plugins.java.Bridges;
import org.sonar.squid.api.CodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
@DependsUpon(value={"BEFORE_SQUID"})
@DependedUpon(value={"squid"})
public class JavaSquidSensor
implements Sensor {
    private final AnnotationCheckFactory annotationCheckFactory;
    private final NoSonarFilter noSonarFilter;
    private final ProjectClasspath projectClasspath;
    private final FileLinesContextFactory fileLinesContextFactory;

    public JavaSquidSensor(RulesProfile profile, NoSonarFilter noSonarFilter, ProjectClasspath projectClasspath, FileLinesContextFactory fileLinesContextFactory) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"squid", (Collection)CheckList.getChecks());
        this.noSonarFilter = noSonarFilter;
        this.projectClasspath = projectClasspath;
        this.fileLinesContextFactory = fileLinesContextFactory;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        List<InputFile> sourceFiles = this.getSourceFiles(project);
        if (sourceFiles.isEmpty()) {
            return;
        }
        Collection checks = this.annotationCheckFactory.getChecks();
        JavaSquid squid = new JavaSquid(this.createConfiguration(project), this.fileLinesContextFactory, checks.toArray(new CodeVisitor[checks.size()]));
        squid.scan(sourceFiles, this.getBytecodeFiles(project));
        new Bridges(squid).save(context, project, (CheckFactory)this.annotationCheckFactory, this.noSonarFilter);
    }

    private List<InputFile> getSourceFiles(Project project) {
        return project.getFileSystem().mainFiles(new String[]{"java"});
    }

    private List<File> getBytecodeFiles(Project project) {
        if (project.getConfiguration().getBoolean("sonar.skipDesign", false)) {
            return Collections.emptyList();
        }
        return this.projectClasspath.getElements();
    }

    private JavaConfiguration createConfiguration(Project project) {
        boolean analyzePropertyAccessors = project.getConfiguration().getBoolean("sonar.squid.analyse.property.accessors", true);
        String fieldNamesToExcludeFromLcom4Computation = project.getConfiguration().getString("sonar.squid.fieldsToExcludeFromLcom4Computation", "LOG, logger");
        Charset charset = project.getFileSystem().getSourceCharset();
        JavaConfiguration conf = new JavaConfiguration(charset);
        conf.setAnalyzePropertyAccessors(analyzePropertyAccessors);
        for (String fieldName : StringUtils.split((String)fieldNamesToExcludeFromLcom4Computation, (char)',')) {
            if (!StringUtils.isNotBlank((String)fieldName)) continue;
            conf.addFieldToExcludeFromLcom4Calculation(fieldName);
        }
        return conf;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

