/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.java.JavaSquid;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.plugins.java.bridges.ChecksBridge;
import org.sonar.plugins.java.bridges.ChidamberKemererBridge;
import org.sonar.plugins.java.bridges.CopyBasicMeasuresBridge;
import org.sonar.plugins.java.bridges.DesignBridge;
import org.sonar.plugins.java.bridges.Lcom4BlocksBridge;
import org.sonar.plugins.java.bridges.NoSonarFilterLoader;
import org.sonar.plugins.java.bridges.PackagesBridge;
import org.sonar.plugins.java.bridges.PublicUndocumentedApiBridge;
import org.sonar.plugins.java.bridges.ResourceIndex;
import org.sonar.plugins.java.bridges.RobertCMartinBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeFactory {
    private BridgeFactory() {
    }

    private static List<Bridge> create(NoSonarFilter noSonarFilter, boolean skipPackageDesignAnalysis) {
        ArrayList result = Lists.newArrayList((Object[])new Bridge[]{new CopyBasicMeasuresBridge(), new PackagesBridge(), new PublicUndocumentedApiBridge(), new NoSonarFilterLoader(noSonarFilter), new ChidamberKemererBridge(), new RobertCMartinBridge(), new Lcom4BlocksBridge(), new ChecksBridge()});
        if (!skipPackageDesignAnalysis) {
            result.add(new DesignBridge());
        }
        return result;
    }

    public static List<Bridge> create(boolean bytecodeScanned, boolean skipPackageDesignAnalysis, SensorContext context, CheckFactory checkFactory, ResourceIndex resourceIndex, JavaSquid squid, NoSonarFilter noSonarFilter) {
        ArrayList<Bridge> result = new ArrayList<Bridge>();
        for (Bridge bridge : BridgeFactory.create(noSonarFilter, skipPackageDesignAnalysis)) {
            bridge.setCheckFactory(checkFactory);
            if (bridge.needsBytecode() && !bytecodeScanned) continue;
            bridge.setContext(context);
            bridge.setSquid(squid);
            bridge.setResourceIndex(resourceIndex);
            result.add(bridge);
        }
        return result;
    }
}

