/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Resource;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lcom4BlocksBridge
extends Bridge {
    protected Lcom4BlocksBridge() {
        super(true);
    }

    @Override
    public void onFile(SourceFile squidFile, Resource sonarFile) {
        List blocks = (List)squidFile.getData(Metric.LCOM4_BLOCKS);
        squidFile.removeMeasure((MetricDef)Metric.LCOM4_BLOCKS);
        if (blocks != null && !blocks.isEmpty()) {
            Measure measure = new Measure(CoreMetrics.LCOM4_BLOCKS, this.serialize(blocks));
            measure.setPersistenceMode(PersistenceMode.DATABASE);
            this.context.saveMeasure(sonarFile, measure);
        }
    }

    protected String serialize(List<Set<AsmResource>> blocks) {
        Collections.sort(blocks, new SetsComparator());
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int indexBlock = 0; indexBlock < blocks.size(); ++indexBlock) {
            blocks.get(indexBlock);
            Set<AsmResource> block = blocks.get(indexBlock);
            if (block.isEmpty()) continue;
            if (indexBlock > 0) {
                sb.append(',');
            }
            sb.append('[');
            this.serializeBlock(block, sb);
            sb.append(']');
        }
        sb.append(']');
        return sb.toString();
    }

    private void serializeBlock(Set<AsmResource> block, StringBuilder sb) {
        List<AsmResource> sortedResources = this.sortResourcesInBlock(block);
        int indexResource = 0;
        for (AsmResource resource : sortedResources) {
            if (indexResource++ > 0) {
                sb.append(',');
            }
            this.serializeResource(resource, sb);
        }
    }

    private void serializeResource(AsmResource resource, StringBuilder sb) {
        sb.append("{\"q\":\"");
        sb.append(Lcom4BlocksBridge.toQualifier(resource));
        sb.append("\",\"n\":\"");
        sb.append(resource.toString());
        sb.append("\"}");
    }

    protected List<AsmResource> sortResourcesInBlock(Set<AsmResource> block) {
        ArrayList result = Lists.newArrayList();
        result.addAll(block);
        Collections.sort(result, new ResourcesComparator());
        return result;
    }

    private static String toQualifier(AsmResource asmResource) {
        if (asmResource instanceof AsmField) {
            return "FLD";
        }
        if (asmResource instanceof AsmMethod) {
            return "MET";
        }
        throw new IllegalArgumentException("Wrong ASM resource: " + asmResource.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourcesComparator
    implements Comparator<AsmResource> {
        private ResourcesComparator() {
        }

        @Override
        public int compare(AsmResource asmResource1, AsmResource asmResource2) {
            int result = this.compareType(asmResource1, asmResource2);
            if (result == 0) {
                result = asmResource1.toString().compareTo(asmResource2.toString());
            }
            return result;
        }

        private int compareType(AsmResource asmResource1, AsmResource asmResource2) {
            if (asmResource1 instanceof AsmField) {
                return asmResource2 instanceof AsmField ? 0 : -1;
            }
            return asmResource2 instanceof AsmMethod ? 0 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetsComparator
    implements Comparator<Set> {
        private SetsComparator() {
        }

        @Override
        public int compare(Set set1, Set set2) {
            return set1.size() - set2.size();
        }
    }
}

