/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.decorators;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;
import org.sonar.java.api.JavaMethod;

public final class FunctionsDecorator
implements Decorator {
    public void decorate(Resource resource, DecoratorContext context) {
        if (Scopes.isProgramUnit((Resource)resource)) {
            int methods = 0;
            int accessors = 0;
            for (DecoratorContext child : context.getChildren()) {
                if (!(child.getResource() instanceof JavaMethod)) continue;
                if (((JavaMethod)child.getResource()).isAccessor()) {
                    ++accessors;
                    continue;
                }
                ++methods;
            }
            context.saveMeasure(new Measure(CoreMetrics.FUNCTIONS, Double.valueOf(methods)));
            context.saveMeasure(new Measure(CoreMetrics.ACCESSORS, Double.valueOf(accessors)));
        }
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }
}

