/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.RecognitionExceptionListener;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.MemoizedMatcher;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsingState {
    private final Token[] tokens;
    public int lexerIndex = 0;
    public final int lexerSize;
    private int outpostMatcherTokenIndex = -1;
    private Matcher outpostMatcher;
    private final Set<RecognitionExceptionListener> listeners = Sets.newHashSet();
    private final AstNode[] astNodeMemoization;
    private final MemoizedMatcher[] astMatcherMemoization;
    public ParsingEventListener[] parsingEventListeners;
    public ExtendedStackTrace extendedStackTrace;

    public ParsingState(List<Token> tokens) {
        this.tokens = tokens.toArray(new Token[tokens.size()]);
        this.lexerSize = this.tokens.length;
        this.astNodeMemoization = new AstNode[this.lexerSize + 1];
        this.astMatcherMemoization = new MemoizedMatcher[this.lexerSize + 1];
    }

    public final Token popToken(Matcher matcher) {
        if (this.lexerIndex >= this.outpostMatcherTokenIndex) {
            this.outpostMatcherTokenIndex = this.lexerIndex;
            this.outpostMatcher = matcher;
        }
        if (this.lexerIndex >= this.lexerSize) {
            throw BacktrackingEvent.create();
        }
        return this.tokens[this.lexerIndex++];
    }

    public final boolean hasNextToken() {
        return this.lexerIndex < this.lexerSize;
    }

    public final Token peekToken(int index, Matcher matcher) {
        if (index > this.outpostMatcherTokenIndex) {
            this.outpostMatcherTokenIndex = index;
            this.outpostMatcher = matcher;
        }
        if (index >= this.lexerSize) {
            throw BacktrackingEvent.create();
        }
        return this.tokens[index];
    }

    public final Token peekToken(Matcher matcher) {
        return this.peekToken(this.lexerIndex, matcher);
    }

    public final Token readToken(int tokenIndex) {
        if (tokenIndex >= this.tokens.length) {
            return null;
        }
        return this.tokens[tokenIndex];
    }

    public final Matcher getOutpostMatcher() {
        return this.outpostMatcher;
    }

    public Token getOutpostMatcherToken() {
        if (this.outpostMatcherTokenIndex >= this.lexerSize || this.outpostMatcherTokenIndex == -1) {
            return null;
        }
        return this.tokens[this.outpostMatcherTokenIndex];
    }

    public final int getOutpostMatcherTokenIndex() {
        return this.outpostMatcherTokenIndex;
    }

    public final int getOutpostMatcherTokenLine() {
        if (this.outpostMatcherTokenIndex < this.lexerSize) {
            return this.tokens[this.outpostMatcherTokenIndex].getLine();
        }
        return this.tokens[this.lexerSize - 1].getLine();
    }

    public final void memoizeAst(MemoizedMatcher matcher, AstNode astNode) {
        astNode.setToIndex(this.lexerIndex);
        this.astNodeMemoization[astNode.getFromIndex()] = astNode;
        this.astMatcherMemoization[astNode.getFromIndex()] = matcher;
    }

    public final void deleteMemoizedAstAfter(int index) {
        for (int i = index; i <= this.outpostMatcherTokenIndex; ++i) {
            this.astMatcherMemoization[i] = null;
            this.astNodeMemoization[i] = null;
        }
    }

    public final boolean hasMemoizedAst(MemoizedMatcher matcher) {
        return this.astMatcherMemoization[this.lexerIndex] == matcher;
    }

    public final AstNode getMemoizedAst(MemoizedMatcher matcher) {
        if (this.hasMemoizedAst(matcher)) {
            return this.astNodeMemoization[this.lexerIndex];
        }
        return null;
    }

    public final Token peekTokenIfExists(int index, Matcher matcher) {
        try {
            return this.peekToken(index, matcher);
        }
        catch (BacktrackingEvent e) {
            return null;
        }
    }

    public final void addListeners(RecognitionExceptionListener ... listeners) {
        for (RecognitionExceptionListener listener : listeners) {
            this.listeners.add(listener);
        }
    }

    public final void notifyListeners(RecognitionException recognitionException) {
        for (RecognitionExceptionListener listener : this.listeners) {
            listener.processRecognitionException(recognitionException);
        }
    }
}

