/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.sonar.sslr.impl.analysis.EmptyAlternative;
import com.sonar.sslr.impl.analysis.GrammarAnalyser;
import com.sonar.sslr.impl.analysis.LeftRecursionException;
import com.sonar.sslr.impl.matcher.MatcherTreePrinter;
import com.sonar.sslr.impl.matcher.OneToNMatcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.io.PrintStream;

public final class GrammarAnalyserStream {
    private GrammarAnalyserStream() {
    }

    public static void print(GrammarAnalyser analyser, PrintStream stream) {
        stream.println("Issues by rule:");
        stream.println("---------------");
        stream.println();
        for (RuleMatcher rule : analyser.getRules()) {
            Exception e;
            if (!analyser.hasIssues(rule)) continue;
            stream.println(rule.getName() + ": *** NOK ***");
            if (analyser.isSkipped(rule)) {
                e = analyser.getSkippedCause(rule);
                stream.println("\tSkipped because of exception: \"" + e.toString() + "\"");
                continue;
            }
            if (analyser.isLeftRecursive(rule)) {
                e = analyser.getLeftRecursionException(rule);
                stream.println("\tThis rule is left recursive!");
                stream.println("\tStack trace:");
                stream.println(((LeftRecursionException)e).getRulesStackTrace());
                continue;
            }
            if (analyser.isDependingOnLeftRecursiveRule(rule)) {
                e = analyser.getLeftRecursionException(rule);
                stream.println("\tThis rule depends on the left recursive rule \"" + ((LeftRecursionException)e).getLeftRecursiveRule().getName() + "\"");
                continue;
            }
            if (analyser.hasEmptyRepetitions(rule)) {
                stream.println("\tThis rule contains the following empty repetitions, which lead to infinite loops:");
                for (OneToNMatcher matcher : analyser.getEmptyRepetitions(rule)) {
                    stream.println("\t\t" + MatcherTreePrinter.print(matcher));
                }
                stream.println();
            }
            if (!analyser.hasEmptyAlternatives(rule)) continue;
            stream.println("\tThis rule contains the following empty alternatives, which lead to dead grammar parts:");
            for (EmptyAlternative emptyAlternative : analyser.getEmptyAlternatives(rule)) {
                stream.println("\t\tAlternative " + MatcherTreePrinter.print(emptyAlternative.getAlternative()) + " in " + MatcherTreePrinter.print(emptyAlternative.getOrMatcher()));
            }
            stream.println();
        }
        stream.println();
        stream.println("End of issues by rule");
        stream.println();
    }
}

