/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.google.common.base.Preconditions;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.util.Stack;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftRecursionException
extends RuntimeException {
    private static final long serialVersionUID = 4398378231378856922L;
    private final Stack<RuleMatcher> stack;

    public LeftRecursionException(Stack<RuleMatcher> stack) {
        int i;
        Preconditions.checkNotNull(stack, (Object)"stack cannot be null");
        Preconditions.checkArgument((stack.size() >= 2 ? 1 : 0) != 0, (Object)"stack size must be at least 2");
        RuleMatcher leftRecursiveRule = (RuleMatcher)stack.get(stack.size() - 1);
        for (i = 0; i < stack.size() - 1 && !leftRecursiveRule.equals(stack.get(i)); ++i) {
        }
        Preconditions.checkArgument((i < stack.size() - 1 ? 1 : 0) != 0, (Object)("the latest added rule \"" + leftRecursiveRule.getName() + "\" should appear twice in the stack"));
        this.stack = stack;
    }

    public RuleMatcher getLeftRecursiveRule() {
        return (RuleMatcher)this.stack.get(this.stack.size() - 1);
    }

    public String getRulesStackTrace() {
        StringBuilder sb = new StringBuilder();
        for (RuleMatcher rule : this.stack) {
            sb.append("\t");
            sb.append("called by ");
            sb.append(rule.getName());
            sb.append(IOUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "The rule \"" + this.getLeftRecursiveRule().getName() + "\" contains a left recursion." + IOUtils.LINE_SEPARATOR + this.getRulesStackTrace();
    }
}

