/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.analysis;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.analysis.OrAnalyser;
import com.sonar.sslr.impl.analysis.Violation;
import com.sonar.sslr.impl.matcher.MatcherTreePrinter;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrAnalyserStream {
    private OrAnalyserStream() {
    }

    public static void print(OrAnalyser orAnalyser, PrintStream stream) {
        OrAnalyserStream.printEmptyViolations(orAnalyser, stream);
        OrAnalyserStream.printPrefixViolations(orAnalyser, stream);
        OrAnalyserStream.printPotentialPrefixViolations(orAnalyser, stream);
    }

    private static void printEmptyViolations(OrAnalyser orAnalyser, PrintStream stream) {
        if (orAnalyser.getEmptyAlternativeViolations().isEmpty()) {
            stream.println("Empty violations: None");
            stream.println();
            return;
        }
        stream.println("Empty violations (" + orAnalyser.getEmptyAlternativeViolations().size() + ")");
        stream.println("----------------");
        OrAnalyserStream.printViolations(orAnalyser.getEmptyAlternativeViolations(), stream);
        stream.println();
    }

    private static void printPrefixViolations(OrAnalyser orAnalyser, PrintStream stream) {
        if (orAnalyser.getPrefixAlternativeViolations().isEmpty()) {
            stream.println("Prefix violations: None");
            stream.println();
            return;
        }
        stream.println("Prefix violations (" + orAnalyser.getPrefixAlternativeViolations().size() + ")");
        stream.println("-----------------");
        OrAnalyserStream.printViolations(orAnalyser.getPrefixAlternativeViolations(), stream);
        stream.println();
    }

    private static void printPotentialPrefixViolations(OrAnalyser orAnalyser, PrintStream stream) {
        if (orAnalyser.getPotentialPrefixAlternativeViolations().isEmpty()) {
            stream.println("Potential prefix violations: None");
            stream.println();
            return;
        }
        stream.println("Potential prefix violations (" + orAnalyser.getPotentialPrefixAlternativeViolations().size() + ")");
        stream.println("---------------------------");
        OrAnalyserStream.printViolations(orAnalyser.getPotentialPrefixAlternativeViolations(), stream);
        stream.println();
    }

    private static void printViolations(List<Violation> violations, PrintStream stream) {
        for (Violation violation : violations) {
            stream.println(" Violation confidence: " + (Object)((Object)violation.getConfidence()));
            stream.println(" In rule: " + (violation.getParentRule() == null ? "[Not Available]" : violation.getParentRule().getName()));
            stream.println(" On or matcher: " + MatcherTreePrinter.print(violation.getRelatedMatcher(0)));
            stream.println(" On alternative: " + MatcherTreePrinter.print(violation.getAffectedMatcher()));
            if (violation.getRelatedMatcher(1) != null) {
                stream.println(" Caused by alternative: " + MatcherTreePrinter.print(violation.getRelatedMatcher(1)));
            }
            if (violation.getProperty("OrAnalyser.PREFIX_EXAMPLE") != null) {
                stream.print(" Example: ");
                List exampleTokens = (List)violation.getProperty("OrAnalyser.PREFIX_EXAMPLE");
                for (Token token : exampleTokens) {
                    stream.print(token.getValue());
                    stream.print(' ');
                }
                stream.println();
            }
            stream.println();
        }
    }
}

