/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnknownCharacterChannel
extends Channel<Lexer> {
    private static final Logger LOG = LoggerFactory.getLogger(UnknownCharacterChannel.class);
    public static final char BOM_CHAR = '\ufeff';
    private boolean shouldLogWarning = false;

    public UnknownCharacterChannel() {
    }

    public UnknownCharacterChannel(boolean shouldLogWarning) {
        this.shouldLogWarning = shouldLogWarning;
    }

    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.peek() != -1) {
            char unknownChar = (char)code.pop();
            if (unknownChar == '\ufeff') {
                return true;
            }
            if (this.shouldLogWarning) {
                LOG.warn("Unknown char: \"" + unknownChar + "\" (" + lexer.getURI() + ":" + code.getLinePosition() + ":" + code.getColumnPosition() + ")");
            }
            Token token = Token.builder().setType(GenericTokenType.UNKNOWN_CHAR).setValueAndOriginalValue(String.valueOf(unknownChar)).setURI(lexer.getURI()).setLine(code.getLinePosition()).setColumn(code.getColumnPosition() - 1).build();
            lexer.addToken(token);
            return true;
        }
        return false;
    }
}

