/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;

public abstract class MemoizedMatcher
extends Matcher {
    public MemoizedMatcher(Matcher ... children) {
        super(children);
    }

    public final AstNode match(ParsingState parsingState) {
        this.enterEvent(parsingState);
        AstNode memoizedAstNode = this.getMemoizedAst(parsingState);
        if (memoizedAstNode != null) {
            this.memoizerHitEvent(parsingState);
            parsingState.lexerIndex = memoizedAstNode.getToIndex();
            this.exitWithMatchEvent(parsingState, memoizedAstNode);
            return memoizedAstNode;
        }
        this.memoizerMissEvent(parsingState);
        int startingIndex = parsingState.lexerIndex;
        try {
            AstNode astNode = this.matchWorker(parsingState);
            if (astNode != null) {
                astNode.setFromIndex(startingIndex);
                astNode.setToIndex(parsingState.lexerIndex);
                this.memoizeAst(parsingState, astNode);
            }
            this.exitWithMatchEvent(parsingState, astNode);
            return astNode;
        }
        catch (BacktrackingEvent re) {
            this.exitWithoutMatchEvent(parsingState);
            throw re;
        }
    }

    private void memoizeAst(ParsingState parsingState, AstNode astNode) {
        parsingState.memoizeAst(this, astNode);
    }

    private AstNode getMemoizedAst(ParsingState parsingState) {
        return parsingState.getMemoizedAst(this);
    }

    protected abstract AstNode matchWorker(ParsingState var1);

    private void memoizerHitEvent(ParsingState parsingState) {
        if (parsingState.parsingEventListeners != null) {
            for (ParsingEventListener parsingEventListener : parsingState.parsingEventListeners) {
                parsingEventListener.memoizerHit(this, parsingState);
            }
        }
    }

    private void memoizerMissEvent(ParsingState parsingState) {
        if (parsingState.parsingEventListeners != null) {
            for (ParsingEventListener parsingEventListener : parsingState.parsingEventListeners) {
                parsingEventListener.memoizerMiss(this, parsingState);
            }
        }
    }

    private void exitWithMatchEvent(ParsingState parsingState, AstNode astNode) {
        block4: {
            if (parsingState.parsingEventListeners == null) break block4;
            if (this instanceof RuleMatcher) {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithMatchRule((RuleMatcher)this, parsingState, astNode);
                }
            } else {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithMatchMatcher(this, parsingState, astNode);
                }
            }
        }
    }

    private void exitWithoutMatchEvent(ParsingState parsingState) {
        block4: {
            if (parsingState.parsingEventListeners == null) break block4;
            if (this instanceof RuleMatcher) {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithoutMatchRule((RuleMatcher)this, parsingState);
                }
            } else {
                for (ParsingEventListener listener : parsingState.parsingEventListeners) {
                    listener.exitWithoutMatchMatcher(this, parsingState);
                }
            }
        }
    }
}

