/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.sonar.sslr.api.AstNodeSkippingPolicy;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.matchers.GrammarElementMatcher;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Grammar {
    public Grammar() {
        this.instanciateRuleFields();
    }

    public static List<Field> getRuleFields(Class grammarClass) {
        Field[] fields = grammarClass.getDeclaredFields();
        ArrayList<Field> ruleFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!Rule.class.isAssignableFrom(field.getType())) continue;
            ruleFields.add(field);
        }
        return ruleFields;
    }

    public static List<Field> getAllRuleFields(Class grammarClass) {
        List<Field> ruleFields = Grammar.getRuleFields(grammarClass);
        for (Class superClass = grammarClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            ruleFields.addAll(Grammar.getRuleFields(superClass));
        }
        return ruleFields;
    }

    private void instanciateRuleFields() {
        for (Field ruleField : Grammar.getAllRuleFields(this.getClass())) {
            String ruleName = ruleField.getName();
            try {
                AstNodeSkippingPolicy rule = this instanceof LexerlessGrammar ? new GrammarElementMatcher(ruleName) : RuleDefinition.newRuleBuilder(ruleName);
                ruleField.setAccessible(true);
                ruleField.set(this, rule);
            }
            catch (Exception e) {
                throw new GrammarException(e, "Unable to instanciate the rule '" + ruleName + "': " + e.getMessage());
            }
        }
    }

    public Rule rule(GrammarRuleKey ruleKey) {
        throw new UnsupportedOperationException();
    }

    public abstract Rule getRootRule();
}

