/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.sonar.sslr.impl.LexerException;
import com.sonar.sslr.impl.ParsingStackTrace;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ExtendedStackTrace;

public class RecognitionException
extends RuntimeException {
    private final int line;
    private final boolean isToRetryWithExtendStackTrace;
    private final boolean isFatal;

    public RecognitionException(ParsingState parsingState, boolean isFatal) {
        super(ParsingStackTrace.generateFullStackTrace(parsingState));
        this.line = parsingState.getOutpostMatcherToken() == null ? 0 : parsingState.getOutpostMatcherToken().getLine();
        this.isToRetryWithExtendStackTrace = true;
        this.isFatal = isFatal;
    }

    public RecognitionException(String message, ParsingState parsingState, boolean isFatal, Throwable e) {
        super(message + "\n" + ParsingStackTrace.generateFullStackTrace(parsingState), e);
        this.line = parsingState.getOutpostMatcherToken() == null ? 0 : parsingState.getOutpostMatcherToken().getLine();
        this.isToRetryWithExtendStackTrace = false;
        this.isFatal = isFatal;
    }

    public RecognitionException(ExtendedStackTrace extendedStackTrace, boolean isFatal) {
        super(extendedStackTrace.toString());
        this.line = extendedStackTrace.longestParsingState.readToken(extendedStackTrace.longestIndex).getLine();
        this.isToRetryWithExtendStackTrace = false;
        this.isFatal = isFatal;
    }

    public RecognitionException(LexerException e) {
        super("Lexer error: " + e.getMessage(), e);
        this.line = 0;
        this.isToRetryWithExtendStackTrace = false;
        this.isFatal = true;
    }

    public RecognitionException(int line, String message) {
        super(message);
        this.line = line;
        this.isToRetryWithExtendStackTrace = false;
        this.isFatal = true;
    }

    public RecognitionException(int line, String message, Throwable cause) {
        super(message, cause);
        this.line = line;
        this.isToRetryWithExtendStackTrace = false;
        this.isFatal = true;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isToRetryWithExtendStackTrace() {
        return this.isToRetryWithExtendStackTrace;
    }

    public boolean isFatal() {
        return this.isFatal;
    }
}

