/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.PreprocessingDirective;
import com.sonar.sslr.api.Token;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trivia {
    private final TriviaKind kind;
    private final List<Token> tokens;
    private final PreprocessingDirective preprocessingDirective;

    private Trivia(TriviaKind kind, Token ... tokens) {
        this(kind, (PreprocessingDirective)null, tokens);
    }

    private Trivia(TriviaKind kind, PreprocessingDirective preprocessingDirective, Token ... tokens) {
        this.kind = kind;
        this.preprocessingDirective = preprocessingDirective;
        this.tokens = ImmutableList.copyOf((Object[])tokens);
    }

    public Token getToken() {
        Preconditions.checkState((!this.tokens.isEmpty() ? 1 : 0) != 0, (Object)"the trivia must have at least one associated token to be able to call getToken()");
        return this.tokens.get(0);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public boolean isComment() {
        return this.kind == TriviaKind.COMMENT;
    }

    public boolean isPreprocessor() {
        return this.kind == TriviaKind.PREPROCESSOR;
    }

    public boolean isSkippedText() {
        return this.kind == TriviaKind.SKIPPED_TEXT;
    }

    public boolean hasPreprocessingDirective() {
        return this.preprocessingDirective != null;
    }

    public PreprocessingDirective getPreprocessingDirective() {
        return this.preprocessingDirective;
    }

    public String toString() {
        if (this.tokens.isEmpty()) {
            return "TRIVIA kind=" + (Object)((Object)this.kind);
        }
        if (this.tokens.size() == 1) {
            Token token = this.tokens.get(0);
            return "TRIVIA kind=" + (Object)((Object)this.kind) + " line=" + token.getLine() + " type=" + token.getType() + " value=" + token.getOriginalValue();
        }
        StringBuilder sb = new StringBuilder();
        for (Token token : this.tokens) {
            sb.append(token.getOriginalValue());
            sb.append(' ');
        }
        return "TRIVIA kind=" + (Object)((Object)this.kind) + " value = " + sb.toString();
    }

    public static Trivia createComment(Token commentToken) {
        return new Trivia(TriviaKind.COMMENT, commentToken);
    }

    public static Trivia createSkippedText(List<Token> tokens) {
        Preconditions.checkNotNull(tokens, (Object)"tokens cannot be null");
        return Trivia.createSkippedText(tokens.toArray(new Token[tokens.size()]));
    }

    public static Trivia createSkippedText(Token ... tokens) {
        return new Trivia(TriviaKind.SKIPPED_TEXT, tokens);
    }

    public static Trivia createPreprocessingToken(Token preprocessingToken) {
        return new Trivia(TriviaKind.PREPROCESSOR, preprocessingToken);
    }

    public static Trivia createPreprocessingDirective(PreprocessingDirective preprocessingDirective) {
        return new Trivia(TriviaKind.PREPROCESSOR, preprocessingDirective, new Token[0]);
    }

    public static Trivia createPreprocessingDirective(AstNode ast, Grammar grammar) {
        return Trivia.createPreprocessingDirective(PreprocessingDirective.create(ast, grammar));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TriviaKind {
        COMMENT,
        PREPROCESSOR,
        SKIPPED_TEXT;

    }
}

