/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.RecognitionExceptionListener;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.LexerException;
import com.sonar.sslr.impl.ParsingStackTrace;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.sslr.parser.ParserAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser<G extends Grammar> {
    private RuleDefinition rootRule;
    private ParsingState parsingState;
    private final Lexer lexer;
    private final G grammar;
    private final Set<RecognitionExceptionListener> listeners;
    private final ParsingEventListener[] parsingEventListeners;
    private final ExtendedStackTrace extendedStackTrace;

    protected Parser(G grammar) {
        this.grammar = grammar;
        this.lexer = null;
        this.listeners = ImmutableSet.of();
        this.parsingEventListeners = new ParsingEventListener[0];
        this.extendedStackTrace = null;
    }

    private Parser(Builder<G> builder) {
        this.lexer = ((Builder)builder).lexer;
        this.grammar = ((Builder)builder).grammar;
        this.listeners = ((Builder)builder).listeners;
        this.extendedStackTrace = ((Builder)builder).extendedStackTrace;
        if (this.extendedStackTrace != null) {
            this.parsingEventListeners = ((Builder)builder).parsingEventListeners.toArray(new ParsingEventListener[((Builder)builder).parsingEventListeners.size() + 1]);
            this.parsingEventListeners[this.parsingEventListeners.length - 1] = this.extendedStackTrace;
        } else {
            this.parsingEventListeners = ((Builder)builder).parsingEventListeners.toArray(new ParsingEventListener[((Builder)builder).parsingEventListeners.size()]);
        }
        GrammarFunctions.resetCache();
        this.rootRule = (RuleDefinition)((Grammar)this.grammar).getRootRule();
    }

    public void printStackTrace(PrintStream stream) {
        stream.append(ParsingStackTrace.generateFullStackTrace(this.getParsingState()));
    }

    public void addListener(RecognitionExceptionListener listerner) {
        this.listeners.add(listerner);
    }

    public AstNode parse(File file) {
        this.fireBeginLexEvent();
        try {
            this.lexer.lex(file);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        finally {
            this.fireEndLexEvent();
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(String source) {
        this.fireBeginLexEvent();
        try {
            this.lexer.lex(source);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        finally {
            this.fireEndLexEvent();
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(List<Token> tokens) {
        this.fireBeginParseEvent();
        try {
            this.parsingState = new ParsingState(tokens);
            this.parsingState.addListeners(this.listeners.toArray(new RecognitionExceptionListener[this.listeners.size()]));
            this.parsingState.parsingEventListeners = this.parsingEventListeners;
            this.parsingState.extendedStackTrace = this.extendedStackTrace;
            AstNode astNode = this.rootRule.getRule().match(this.parsingState);
            astNode.hasToBeSkippedFromAst();
            AstNode astNode2 = astNode;
            return astNode2;
        }
        catch (BacktrackingEvent e) {
            throw this.extendedStackTrace == null ? new RecognitionException(this.parsingState, true) : new RecognitionException(this.extendedStackTrace, true);
        }
        finally {
            this.fireEndParseEvent();
        }
    }

    private void fireBeginLexEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.beginLex();
            }
        }
    }

    private void fireEndLexEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.endLex();
            }
        }
    }

    private void fireEndParseEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.endParse();
            }
        }
    }

    private void fireBeginParseEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.beginParse();
            }
        }
    }

    public ParsingState getParsingState() {
        return this.parsingState;
    }

    public G getGrammar() {
        return this.grammar;
    }

    public RuleDefinition getRootRule() {
        return this.rootRule;
    }

    public void setRootRule(Rule rootRule) {
        this.rootRule = (RuleDefinition)rootRule;
    }

    public static <G extends Grammar> Builder<G> builder(G grammar) {
        return new Builder(grammar, null);
    }

    public static <G extends Grammar> Builder<G> builder(Parser<G> parser) {
        return new Builder(parser);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<G extends Grammar> {
        private Parser<G> baseParser;
        private Lexer lexer;
        private final G grammar;
        private final Set<ParsingEventListener> parsingEventListeners = new HashSet<ParsingEventListener>();
        private final Set<RecognitionExceptionListener> listeners = new HashSet<RecognitionExceptionListener>();
        private ExtendedStackTrace extendedStackTrace;

        private Builder(G grammar) {
            this.grammar = grammar;
        }

        private Builder(Parser<G> parser) {
            this.baseParser = parser;
            this.lexer = ((Parser)parser).lexer;
            this.grammar = ((Parser)parser).grammar;
            this.setParsingEventListeners(((Parser)parser).parsingEventListeners);
            this.setRecognictionExceptionListener(((Parser)parser).listeners.toArray(new RecognitionExceptionListener[((Parser)parser).listeners.size()]));
            this.extendedStackTrace = ((Parser)parser).extendedStackTrace;
        }

        public Parser<G> build() {
            if (this.baseParser instanceof ParserAdapter) {
                return this.baseParser;
            }
            return new Parser(this);
        }

        public Builder<G> withLexer(Lexer lexer) {
            this.lexer = lexer;
            return this;
        }

        public Builder<G> setParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            this.parsingEventListeners.clear();
            this.addParsingEventListeners(parsingEventListeners);
            return this;
        }

        public Builder<G> addParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            for (ParsingEventListener parsingEventListener : parsingEventListeners) {
                this.parsingEventListeners.add(parsingEventListener);
            }
            return this;
        }

        public Builder<G> setRecognictionExceptionListener(RecognitionExceptionListener ... listeners) {
            this.listeners.clear();
            this.addRecognictionExceptionListeners(listeners);
            return this;
        }

        public Builder<G> addRecognictionExceptionListeners(RecognitionExceptionListener ... listeners) {
            for (RecognitionExceptionListener listener : listeners) {
                this.listeners.add(listener);
            }
            return this;
        }

        public Builder<G> setExtendedStackTrace(ExtendedStackTrace extendedStackTrace) {
            this.extendedStackTrace = extendedStackTrace;
            return this;
        }

        /* synthetic */ Builder(Grammar x0, 1 x1) {
            this(x0);
        }
    }
}

