/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.events;

import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastStackMatcherAndPosition {
    private static final int INITIAL_CAPACITY = 800;
    private Matcher[] matchers = new Matcher[800];
    private int[] fromIndex = new int[800];
    private int[] toIndex = new int[800];
    private int i = 0;

    public static void copyOnlyRuleMatchers(FastStackMatcherAndPosition result, FastStackMatcherAndPosition source, Stack<Integer> ruleIndexes) {
        int oldSize = result.i;
        if (result.matchers.length < ruleIndexes.size()) {
            result.matchers = new Matcher[source.matchers.length];
            result.fromIndex = new int[source.fromIndex.length];
            result.toIndex = new int[source.toIndex.length];
        }
        int i = 0;
        for (Integer ruleIndex : ruleIndexes) {
            result.matchers[i] = source.matchers[ruleIndex];
            result.fromIndex[i] = source.fromIndex[ruleIndex];
            result.toIndex[i] = source.toIndex[ruleIndex];
            ++i;
        }
        result.i = i;
        while (i < oldSize) {
            result.matchers[i] = null;
            ++i;
        }
    }

    public int peek() {
        return this.i - 1;
    }

    public Matcher peekMatcher() {
        return this.matchers[this.i - 1];
    }

    public RuleMatcher peekRule() {
        return (RuleMatcher)this.matchers[this.i - 1];
    }

    public int peekFromIndex() {
        return this.fromIndex[this.i - 1];
    }

    public int peekToIndex() {
        return this.toIndex[this.i - 1];
    }

    public void pop() {
        --this.i;
        this.matchers[this.i] = null;
    }

    public Matcher getMatcher(int i) {
        return this.matchers[i];
    }

    public RuleMatcher getRule(int i) {
        return (RuleMatcher)this.matchers[i];
    }

    public int getFromIndex(int i) {
        return this.fromIndex[i];
    }

    public int getToIndex(int i) {
        return this.toIndex[i];
    }

    public void setToIndex(int i, int value) {
        this.toIndex[i] = value;
    }

    public void push(Matcher matcher, int fromIndex) {
        if (this.i >= this.matchers.length) {
            Matcher[] newMatchers = new Matcher[this.matchers.length * 2];
            System.arraycopy(this.matchers, 0, newMatchers, 0, this.matchers.length);
            this.matchers = newMatchers;
            int[] newFromIndex = new int[this.fromIndex.length * 2];
            System.arraycopy(this.fromIndex, 0, newFromIndex, 0, this.fromIndex.length);
            this.fromIndex = newFromIndex;
            int[] newToIndex = new int[this.toIndex.length * 2];
            System.arraycopy(this.toIndex, 0, newToIndex, 0, this.toIndex.length);
            this.toIndex = newToIndex;
        }
        this.matchers[this.i] = matcher;
        this.fromIndex[this.i] = fromIndex;
        ++this.i;
    }

    public int size() {
        return this.i;
    }

    public void clear() {
        while (--this.i >= 0) {
            this.matchers[this.i] = null;
        }
        this.i = 0;
    }
}

