/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.StandardMatcher;

public abstract class TokenMatcher
extends StandardMatcher {
    private final boolean hasToBeSkippedFromAst;

    public TokenMatcher(boolean hasToBeSkippedFromAst) {
        super(new Matcher[0]);
        this.hasToBeSkippedFromAst = hasToBeSkippedFromAst;
    }

    protected final Matcher.MatchResult doMatch(ParsingState parsingState) {
        this.enterEvent(parsingState);
        int startingIndex = parsingState.lexerIndex;
        Token token = parsingState.peekTokenIfExists(parsingState.lexerIndex, this);
        if (token != null && this.isExpectedToken(token)) {
            token = parsingState.popToken(this);
            AstNode astNode = this.hasToBeSkippedFromAst ? null : new AstNode(token);
            this.exitWithMatchEvent(parsingState, astNode);
            return Matcher.MatchResult.succeed(parsingState, startingIndex, astNode);
        }
        this.exitWithoutMatchEvent(parsingState);
        return Matcher.MatchResult.fail(parsingState, startingIndex);
    }

    protected abstract boolean isExpectedToken(Token var1);
}

